/***
* ostream1.cxx - definitions for ostream class non-core member functions
*
*	Copyright (c) 1991-1992, Microsoft Corporation.  All rights reserved.
*
*Purpose:
*	Contains the non-core member function definitions for ostream class.
*
*******************************************************************************/

#include <internal.h>
#include <iostream.h>
#pragma hdrstop

ostream& ostream::seekp(streampos _strmp)
{
    if (bp->seekpos(_strmp, ios::out)==EOF)
	state |= failbit;
    return(*this);
}

ostream& ostream::seekp(streamoff _strmf, seek_dir _sd)
{
    if (bp->seekoff(_strmf, _sd, ios::out)==EOF)
	state |= failbit;
    return(*this);
}

streampos ostream::tellp()
{
    streampos retval;
    if ((retval=bp->seekoff(streamoff(0), ios::cur, ios::out))==EOF)
	state |= failbit;
    return(retval);
}

ostream& ostream::operator<<(streambuf * instm)
{
    int c;
    if (opfx())
	{
	while ((c=instm->sbumpc())!=EOF)
	    if (bp->sputc(c) == EOF)
		{
		state |= failbit;	// CONSIDER: is this redundent?
		break;
		}
// CONSIDER: not very efficient in many cases
	osfx();
	}
    return *this;
}
