/***
*commit.c - flush buffer to disk
*
*   Copyright (c) 1990-1992, Microsoft Corporation. All rights reserved.
*
*Purpose:
*       contains _commit() - flush buffer to disk
*
*******************************************************************************/

 #include <dos.h>   // for _dos_commit

#include <errno.h>
#include <io.h>
#include <internal.h>
#include <msdos.h>  // for FOPEN
#include <register.h>
#include <stdlib.h> // for _osmajor/minor and _doserrno

#ifdef _QWIN
// maximum std i/o file handle
#define _MAX_STDFH 2
#endif

/***
*int _commit(filedes) - flush buffer to disk
*
*Purpose:
*   Flushes cache buffers for the specified file handle to disk
*
*Entry:
*   int filedes - file handle of file
*
*Exit:
*   returns success code
*
*Exceptions:
*
*******************************************************************************/

int  _commit (filedes)
REG1 int filedes;
{
    REG2 int retval;

#ifdef _QWIN
    if (filedes < 0 || filedes >= _wnfile)
#else
    if (filedes < 0 || filedes >= _nfile)
#endif
    {
        errno = EBADF;
        return (-1);
    }

#ifdef _QWIN
    /* Return success on QWIN files */
    if (_qwinused)
    {
        if ( (filedes >= _nfile) || (filedes <= _MAX_STDFH) )
            return(0);
    }
#endif

    /* Commit was not supported before DOS 3.30 */
    if ((_osmajor << 8) + _osminor < (0x300 + 30)) {
        return (0L);
    }


    // if filedes open, try to commit, else fall through to bad
    if (_osfile[filedes] & FOPEN) {

        retval = _dos_commit(filedes);

        // map the OS return code to C errno value and return code
        if (retval == 0) {
            goto good;
        } else {
            _doserrno = retval;
            goto bad;
        }

    }

bad :
    errno = EBADF;
    retval = -1;
good :
    return (retval);
}
