	page	,132
	title	creat - creat a new file or truncate an existing one
;***
;creat.asm - create a new file or truncate existing file
;
;	Copyright (c) 1986-1992, Microsoft Corporation. All rights reserved.
;
;Purpose:
;	defines creat() - create new file
;
;*******************************************************************************

include version.inc
	.xlist
include cmacros.inc
include fcntl.inc
	.list

externP _open

sBegin	code

	assumes cs,code
	assumes ds,data

page
;***
;int _creat(path, pmode) - create a new file
;
;Purpose:
;	If file specified does not exist, creat creates a new file
;	with the given permission setting and opens it for writing.
;	If the file already exists and its permission allows writing,
;	create truncates it to 0 length and open it for writing.
;	The only Xenix mode bit supprted by DOS is user write (S_IWRITE).
;
;Entry:
;	char *path - filename to create
;	int pmode - permission mode setting for new file
;
;Exit:
;	returns handle for created file
;	returns -1 and sets errno if fails.
;
;Uses:
;
;Exceptions:
;
;*******************************************************************************

cProc	_creat,<PUBLIC>,<>

	parmdp	cpath
	parmw	cmode

cBegin

;	All we are going to do for this is to call
;		open(cpath,O_CREAT+O_TRUNC+O_RDWR, cmode)
;	Note we must push args in reverse order and fixup the stack upon return.

	push	[cmode] 	; permission mode for open()
	mov	ax,O_CREAT+O_TRUNC+O_RDWR
	push	ax		; access flags for open()
if	sizeD
	push	word ptr (cpath+2)
endif
	push	word ptr (cpath) ; path name of file
	callcrt _open
if	sizeD
	add	sp,8
else
	add	sp,6
endif

cEnd

sEnd
	end
