/***
*chsize.c - change size of a file
*
*   Copyright (c) 1985-1992, Microsoft Corporation. All rights reserved.
*
*Purpose:
*   Defines chsize() - change size of a file
*
*******************************************************************************/

#include <errno.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <msdos.h>
#include <register.h>
#include <assert.h>
#include <fcntl.h>
#include <dos.h>
#include <io.h>
#include <internal.h>
#include <sizeptr.h>

#pragma check_stack+        /* turn stack probes on */


/***
*int _chsize(filedes, size) - change size of a file
*
*Purpose:
*   Change file size. Assume file is open for writing, or we can't do it.
*   The dos way to do this is to go to the right spot and write 0 bytes.
*   The Xenix way to do this is to make a system call. We write '\0' bytes
*   because DOS won't do this for you if you lseek beyond eof, though Xenix
*   will.
*
*Entry:
*   int filedes - file handle to change size of
*   long size   - new size of file
*
*Exit:
*   return 0 if successful
*   returns -1 and sets errno if fails
*
*Exceptions:
*
*******************************************************************************/

int
_chsize (filedes, size)
REG1 int filedes;
long size;
{
    long extend;
    long place;
    _WINSTATIC union _REGS regs;


    int cnt;
    _WINSTATIC char blanks[BUFSIZ];

#ifdef  SIZED
    struct _SREGS sregs;
    char *bl = blanks;
#else
    REG2 char *bl = blanks;
#endif

    REG3 char oldmode;

    assert(filedes >= 0);
    assert(size >= 0);

    if ((place = _lseek( filedes, 0L, 1 )) == -1)
        return(-1);

    if ((extend = ( size - _lseek(filedes, 0L, 2) )) > 0L)
    {

        /* extending the file */

        memset(bl, '\0', BUFSIZ);

        /* by this time we know we have a valid file handle */

        oldmode = _osfile[filedes];
        _osfile[filedes] &= ~FTEXT;

        /* mode is now set to binary */

        do  {
            extend -= ( long ) ( cnt = (extend >= (long)BUFSIZ ) ?
            BUFSIZ : (int)extend );
            if (  ( cnt = _write( filedes, bl, cnt ) ) == -1 ) {
                _osfile[filedes] = oldmode;
                if ( _doserrno == 5 )
                    errno = EACCES;
                return( cnt );
            }
        }
        while ( extend );

        _osfile[filedes] = oldmode;
        _lseek( filedes, place, 0 );
        return(0);
    }
    else {

        /* shortening the file */

        _lseek(filedes, size, 0);
        regs.x.ax = DOS_write << 8;
        regs.x.bx = filedes;
        regs.x.cx = 0x0000;
#ifdef  SIZED
        sregs.ds = sregs.es = FP_SEG( bl );
        regs.x.dx = FP_OFF( bl );
        _intdosx( &regs, &regs, &sregs );
#else
        regs.x.dx = (unsigned)bl;
        _intdos( &regs, &regs );
#endif
        _lseek( filedes, place, 0 );
        return( regs.x.cflag ? -1 : regs.x.ax );
        /*  return(_write(filedes, bl, 0)); */
    }
}
