	page	,132
	title	close - close file handle
;***
;close.asm - close file handle
;
;	Copyright (c) 1985-1992, Microsoft Corporation. All rights reserved.
;
;Purpose:
;	defines close() - close a file handle
;
;*******************************************************************************

include version.inc
.xlist
include cmacros.inc
include msdos.inc
include errno.inc
.list

sBegin	data

assumes ds,data

extrn	__osfile:byte		; file handle flags, etc.
extrn	__nfile:word		; Maximum number of file handles

sEnd


page

extrn	__dosret0:near

sBegin	code

	assumes cs,code
	assumes ds,data

page
;***
;int _close(fh) - close a file handle
;
;Purpose:
;	Closes the file associated with the file handle fh.
;
;Entry:
;	int fh - file handle to close
;
;Exit:
;	returns 0 if successful, -1 (and sets errno) if fails
;
;Uses:
;
;Exceptions:
;
;*******************************************************************************


cProc	_close,<PUBLIC>,<>

	parmw	clfh

cBegin
	mov	bx,clfh 	; file handle
	cmp	bx,__nfile
	jb	fh_okay

	mov	ax,EBADF shl 8 + 0 ; Error: file handle is not valid
	stc
	jmp	short closeret	; return error

fh_okay:
	callos	close
	jc	closeret

	mov	__osfile[bx],0	; clear file flags

closeret:
	jmp	__dosret0	; return 0 if successful

cEnd	nogen

sEnd
	end
