	page	,132
	title	dup  - dup, dup2
;***
;dup.asm - duplicate file handles
;
;	Copyright (c) 1985-1992, Microsoft Corporation. All rights reserved.
;
;Purpose:
;	defines dup() and dup2() - duplicate file handles
;
;*******************************************************************************

include version.inc
.xlist
include cmacros.inc
include msdos.inc
include errno.inc
ifdef _QWIN
include stdlib.inc
endif
.list

extrn	__dosret0:near
extrn	__dosretax:near

sBegin	data
assumes ds,data

extrn	__osfile:byte		; file handle flags, etc.
extrn	__nfile:word		; Maximum number of file handles

ifdef _QWIN
extrn	__qwinused:word 	; QWIN system in use flag
endif

sEnd

sBegin	code

	assumes cs,code
	assumes ds,data

page
;***
;int _dup(fh) - duplicate a file handle
;
;Purpose:
;	Assigns another file handle to the file associated with the
;	handle fh.  The next available file handle is assigned.
;
;	NOTE !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
;	there is a bug in dos 2.x. if file handle 0 or 1 is dup'ed, then
;	closed, any following i/o on the file handles dup'ed will be lost.
;	for this reason, _cleanup has been modified to call fflush on all
;	streams before fclose'ing them. this is only partial protection.
;	the user can still get screwed if he fools around with dup() and
;	close() and write() directly, and there's no way to save him.
;	NOTE !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
;
ifdef _QWIN
;	Note:  Can not dup QWIN windows file handles!
endif
;
;Entry:
;	int fh - file handle to duplicate
;
;Exit:
;	returns new file handle if successful
;	returns -1 (and sets errno) if fails
;
;Uses:
;	AX, BX, CX, DX
;
;Exceptions:
;
;*******************************************************************************
;
;
;
	public	__dup

cProc	__dup,<>,<>

	parmw	fh

cBegin
	mov	bx,fh		; file handle to dup
ifdef _QWIN
	; only non-QWIN files are allowed
ifndef _BAT16
	cmp	[__qwinused],0	; QWIN system enabled ??
	je	@F		; nope, continue
endif
	cmp	bx,_MAX_STDFH	; yes, is handle std file ??
	jbe	fh_error	; if so, error
@@:
	;fall thru		; make sure it's an OS file handle
endif
	cmp	bx,[__nfile]
	jb	fh_in_okay

fh_error:
	mov	ax,EBADF shl 8 + 0 ; handle out of range
	stc
	jmp	short dupret

fh_in_okay:
	callos	dup		; duplicate file handle
	jc	dupret

	cmp	ax,[__nfile]
	jb	fh_okay 	; is the file handle in range?

	mov	bx,ax
	callos	close

	mov	ax,EMFILE shl 8 + 0 ; no more valid handles
	stc
	jmp	short dupret
fh_okay:
	mov	cl,__osfile[bx] ; copy the information byte
	mov	bx,ax
	mov	__osfile[bx],cl
	clc
dupret:
	jmp	__dosretax	; return new handle if successful

cEnd	nogen

page
;***
;int _dup2(fh1, fh2) - force handle 2 to refer to handle 1
;
;Purpose:
;	Forces file handle 2 to refer to the same file as file
;	handle 1.  If file handle 2 referred to an open file, that file
;	is closed.
;
;	NOTE !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
;	there is a bug in dos 2.x. if file handle 0 or 1 is dup'ed, then
;	closed, any following i/o on the file handles dup'ed will be lost.
;	for this reason, _cleanup has been modified to call fflush on all
;	streams before fclose'ing them. this is only partial protection.
;	the user can still get screwed if he fools around with dup() and
;	close() and write() directly, and there's no way to save him.
;	NOTE !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
;
ifdef _QWIN
;	Note:  Can not dup QWIN windows file handles!
endif
;
;Entry:
;	int fh1 - file handle to duplicate
;	int fh2 - file handle to assign to file handle 1
;
;Exit:
;	returns 0 if successful, -1 (and sets errno) if fails.
;
;Uses:
;	AX, BX, CX, DX
;
;Exceptions:
;
;*******************************************************************************

cProc	_dup2,<PUBLIC>,<>

	parmw	fh
	parmw	newfh

cBegin

ifdef _QWIN
	; make sure both handles are in OS file handle range
	; (i.e., not in the QWIN file handle range).
endif
	mov	bx,fh		; existing file handle
	cmp	bx,[__nfile]
	jae	fh_error

	mov	cx,newfh	; new file handle number
	cmp	cx,[__nfile]
	jae	fh_error

ifdef	_QWIN
ifndef 	_BAT16
	cmp	[__qwinused],0	; is QWIN system enabled ??
	jz	@F		; nope, continue
endif
	cmp	bx,_MAX_STDFH	; yes, is bx a std i/o handle ??
	jbe	fh_error	; if so, error
	cmp	cx,_MAX_STDFH	; yes, is cx a std i/o handle ??
	jbe	fh_error	; if so, error
@@:
	;fall thru		; neither handle is a QWIN file
endif

	callos	forcedup	; force duplicate file handle
	jc	dup2ret

	mov	dl,__osfile[bx] ; copy the information byte
	mov	bx,cx
	mov	__osfile[bx],dl
dup2ret:
	jmp	__dosret0	; return 0 if successful

cEnd	nogen

sEnd
	end
