/***
*fstat.c - obtain file status info
*
*   Copyright (c) 1985-1992, Microsoft Corporation. All rights reserved.
*
*Purpose:
*   defines fstat() - obtain file status info
*
*******************************************************************************/

#include <sys/types.h>
#include <sys/stat.h>
#include <errno.h>
#include <register.h>
#include <msdos.h>
#include <dos.h>
#include <dostypes.h>
#include <io.h>
#include <internal.h>

#define IO_DEVNBR   0x3f
#define ISDEV       0x80



/***
*int _fstat(filedes, buf) - get file status info
*
*Purpose:
*   Fills the supplied buffer with status information on the specified
*   file descriptor.
*
*Entry:
*   int filedes  - file descriptor
*   struct stat *buf - buffer to store file info in
*
*Exit:
*   fills in structure pointed to by buf
*   returns 0 if successful
*   returns -1 and sets errno if unsuccessful
*
*Exceptions:
*
*******************************************************************************/

_fstat(fildes, buf)
REG2 int fildes;
REG1 struct _stat *buf;
{
    long cpos;
    int isdev;
    _WINSTATIC union _REGS inregs;
    _WINSTATIC union _REGS outregs;

    /* Check the validity of the fildes by doing a get-device-info call.
     * This also gives us other information we may need later
     */

    inregs.x.ax = (DOS_ioctl << 8);
    inregs.x.bx = fildes;
    _intdos(&inregs,&outregs);

    if (outregs.x.cflag)    /* carry set - bad file designator */
        return(-1);

    isdev = (outregs.x.dx & ISDEV);

    buf->st_rdev = buf->st_dev = (outregs.x.dx & IO_DEVNBR);
    buf->st_uid = buf->st_gid = buf->st_mode = 0;
    buf->st_ino = fildes;
    buf->st_nlink = 1;

    buf->st_mode |= (_osfile[fildes] & FRDONLY)
    ? (S_IREAD + (S_IREAD >> 3) + (S_IREAD >> 6))
    : ((S_IREAD|S_IWRITE) + ((S_IREAD|S_IWRITE) >> 3)
    + ((S_IREAD|S_IWRITE) >> 6));

    /* set file date fields - NOTE for code below, it should be
     * remembered that inregs.x.bx is already set to filedes
     * and the calls to filedate cannot fail since the file handle
     * is known to be good since we got by the DOS_ioctl call above.
     */

    inregs.x.ax = (DOS_filedate << 8);
    _intdos(&inregs,&outregs);

    buf->st_atime = buf->st_mtime = buf->st_ctime =
    XTIME(outregs.x.dx, outregs.x.cx);

    /* check for device or file */

    if (isdev) {

        /* file designator refers to a device - set file size to 0*/

        buf->st_size = 0;

        buf->st_rdev = buf->st_dev = fildes;
        buf->st_mode |= S_IFCHR;
    }
    else {

        /* file designator refers to a regular file - set actual file
         * size
         */
        cpos = _lseek(fildes, 0L, 1);
        buf->st_size = _lseek(fildes, 0L, 2);
        _lseek(fildes, cpos, 0);

        buf->st_mode |= S_IFREG;
    }
    return(0);
}
