	page	,132
	title	locking - file locking function
;***
;locking.asm - file locking/unlocking function
;
;	Copyright (c) 1985-1992, Microsoft Corporation. All rights reserved.
;
;Purpose:
;	defines locking() - file locking/unlocking function
;
;*******************************************************************************

.xlist
include version.inc
include cmacros.inc
include msdos.inc
include errno.inc
.list



sBegin	data
assumes ds,data
retry	db	0		; retry count for blocking locks
mins	db	0		; current minute
hsecs	dw	0		; seconds and hundredths in hundreths
sEnd

extrn	__dosret0:near

sBegin	code

	assumes cs,code
	assumes ds,data

page
;***
;int _locking(fh,mode,nbytes) - file record locking function
;
;Purpose:
;	Locks or unlocks nbyte bytes of the file specified.
;
;Entry:
;	int fh -	file handle
;	int mode -	new position(mode)
;	long nbytes -	number of bytes to lock/unlock
;
;Exit:
;	returns 0 if successful
;	returns -1 and sets errno if unsuccessful
;
;Uses:
;
;Exceptions:
;
;*******************************************************************************


cProc	_locking,<PUBLIC>,<>

	parmw	fh
	parmw	mode
	parmd	nbytes

cBegin
	push	si		; save si and di, trashed by locking call
	push	di
	mov	byte ptr (retry),10 ; set retry count

; find current position

	mov	bx,fh		; file handle
	xor	cx,cx
	mov	dx,cx		; 0L
	mov	ax,DOS_lseek shl 8 + 1 ; relative to current location
	callos
	jnc	found
	jmp	short lockerr 	; seek failed, must be bad file handle

found:

; attempt to lock/unlock file as requested - note that bx already contains
; the file handle from the call to lseek, and dx:ax contains the current
; file offset

	mov	cx,dx
	mov	dx,ax		; move current offset from dx:ax to cx:dx
	mov	di,word ptr (nbytes)
	mov	si,word ptr (nbytes)+2 ; move number of bytes into si:di
	mov	ax,DOS_locking shl 8 + 0
	cmp	word ptr (mode),0
	jnz	docall		; attempting to lock region
	mov	al,1		; attempting to unlock region
docall:
	callos
ifdef _WINDOWS
	jnc	lockret0	; indirection (so jump is in range)
else
	jnc	lockret 	; it succeeded, return
endif

chkerr:

; note the error cannot be an invalid file handle since that would have
; been caught by the lseek at the start of this routine, so the lock/unlock
; request must have failed.  If this was an unlock or non-blocking lock
; (LK_NBLCK or LK_NBRLCK) request then return an access error, otherwise
; retry up to 10 times, sleeping for 1 second in between each retry.  If,
; after 10 retries we still fail, return a deadlock error.

	cmp	ax,1		; sharing installed?
	je	lockerr 	; no get out of possible loop

	test	word ptr (mode),1 ; blocking mode (LK_LOCK/LK_RLOCK)?
	jnz	tryagain	; yup, sleep and try again
	;fall thru to lockerr
				; the above test may have changed the carry flag
;
; Common returns
;
lockerr:
	stc			; carry set = error
lockret0:
ifdef _WINDOWS
	jmp	lockret 	; clean stack and return error
else
	jmp	short lockret 	; clean stack and return error
endif


; we have a blocking lock request, sleep for 1 second and tryagain up to
; 10 times.  If we still can't satisfy the locking request, return DEADLK
; error

tryagain:

	cmp	byte ptr (retry),0 ; more retries left?
	jnz	doretry 	; yes, sleep and retry
	mov	ah,EDEADLOCK	; no, return deadlock error
	jmp	lockerr

doretry:
	dec	byte ptr (retry) ; decrement number of retries
	push	cx		; save current file position
	push	dx

; now go into a one second wait loop using the DOS get time function

	callos	gettime 	; get current time
	mov	al,dh		; seconds
	cbw			; convert to hundredths of a second
	mov	bx,100
	imul	bx
	xor	dh,dh		; add hundredths value returned by gettime
	add	ax,dx
	mov	byte ptr (mins), cl ; save minutes value
	mov	word ptr (hsecs),ax ; save hundredths total
doloop:
	callos	gettime 	; get time value again
	mov	al,dh
	cbw			; convert to hundreths of a second
	mov	bx,100
	imul	bx
	xor	dh,dh
	add	ax,dx
	cmp	cl, byte ptr (mins) ; see if we wrapped around
	je	docmp		; no, compare times
	add	ax,6000 	; yes, add 1 minute in hundredths of a second
docmp:
	sub	ax,word ptr(hsecs) ; compare new time and old time
	cmp	ax,100		; more than 1 sec elapsed (100 hundredths)?
	jl	doloop		; no, loop again

; wait loop is over, try the lock again

	pop	dx		; restore saved file position
	pop	cx
	mov	di,word ptr (nbytes)
	mov	si,word ptr (nbytes)+2 ; move number of bytes into si:di
	mov	bx,fh		; file handle
	mov	ax,DOS_locking shl 8 + 0
	callos			; attempt to lock file

ifdef _WINDOWS
	; necessary logic to keep jump in range
	jnc	lockret 	; success, all done
	jmp	tryagain	; failure, try again
else
	jc	tryagain	; if failed, try again
endif

lockret:
	pop	di		; clean up stack
	pop	si
	jmp	__dosret0

cEnd	nogen

sEnd
	end
