	page	,132
	title	lseek - change file position
;***
;lseek.asm - change file position
;
;	Copyright (c) 1985-1992, Microsoft Corporation. All rights reserved.
;
;Purpose:
;	defines lseek() - move the file pointer
;
;*******************************************************************************

include version.inc
.xlist
include cmacros.inc
include msdos.inc
include errno.inc
ifdef _QWIN
include stdlib.inc
endif
.list


sBegin	data
	assumes ds,data

extrn	__osfile:byte		; file handle flags, etc.
extrn	__nfile:word		; Maximum number of file handles

extrn	__lseekchk:word 	; lseek error check flag

ifdef _QWIN
extrn	__qwinused:word 	; QWIN system in use flag
endif

sEnd

extrn	__dosretax:near

sBegin	code

	assumes cs,code
	assumes ds,data

page
;***
;long _lseek(fh,pos,mthd) - move the file pointer
;
;Purpose:
;	Moves the file pointer associated with fh to a new position.
;	The new position is pos bytes (pos may be negative) away
;	from the origin specified by mthd.
;
;	If mthd == SEEK_SET, the origin in the beginning of file
;	If mthd == SEEK_CUR, the origin is the current file pointer position
;	If mthd == SEEK_END, the origin is the end of the file
;
ifdef _QWIN
;	Note:  Can't seek on QWIN file handles!
endif
;
;Entry:
;	int fh - file handle to move file pointer on
;	long pos - position to move to, relative to origin
;	int mthd - specifies the origin pos is relative to (see above)
;
;Exit:
;	returns the offset, in bytes, of the new position from the beginning
;	of the file.
;	returns -1L (and sets errno) if fails.
;	Note that seeking beyond the end of the file is not an error.
;	(although seeking before the beginning is.)
;
;Uses:
;
;Exceptions:
;
;*******************************************************************************


cProc	_lseek,<PUBLIC>,<>

	parmw	fh
	parmd	pos
	parmw	mthd
	localW	hiword
	localW	loword

cBegin
	mov	bx,fh		; file handle

ifdef _QWIN
	; make sure handle is in OS file handle range
	; (i.e., not in the QWIN file handle range).
endif
	cmp	bx,__nfile
	jb	handle_okay

ifdef	_QWIN
ifndef	_BAT16
	cmp	[__qwinused],0	; is QWIN system enabled ??
	jz	handle_okay	; nope, continue
endif
	cmp	bx,_MAX_STDFH	; yes, is bx a std i/o handle ??
	ja	handle_okay	; no, continue
	; fall thru		; yes, error
endif

;
; _dosret must set DX:AX to -1L
;
	mov	ax,EBADF shl 8 + 0 ; file handle is out of range
	jmp	short seterr

;
; check to see if we need to do the negative offset check
;

handle_okay:
	cmp	word ptr [__lseekchk],0 ; check for neg offset ??
	je	doit			; jump, if not

;
; negative offset - due to a DOS idiosyncracy, we have to check here to see
; if the seek would move us to a location prior to the beginning of the
; file, and, if so, return an error.
;

	test	word ptr (pos)+2,8000h ; negative offset ?
	jz	doit		; not negative; just do lseek

	cmp	mthd,0		; byte 0 relative?
	je	negative	; yes, error

	xor	cx,cx		; no, find current position
	mov	dx,cx		; 0L
	mov	ax,DOS_lseek shl 8 + 1
	callos
	jc	errexit 	; if error

	test	mthd,2		; must be 1 or 2, or lseek would have
				; just failed
	jnz	findeof 	; mthd is 2
				; mthd is 1
	add	ax,word ptr (pos) ; low word
	adc	dx,word ptr (pos)+2 ; hi word
	jns	doit		; net position is not negative; do lseek

negative:			; net position is negative, return
	mov	ax,EINVAL shl 8 + 0 ; invalid value error
seterr:
	stc
	jmp	short errexit

findeof:			; mthd is relative to end of file
	mov	hiword,dx	; save present position (dx:ax)
	mov	loword,ax
	mov	dx,cx		; 0L - cx is still zero from previous call
	mov	ax,DOS_lseek shl 8 + 2 ; find eof position
	callos
	add	ax,word ptr (pos) ; low word
	adc	dx,word ptr (pos)+2 ; hi word
	jns	doit		; if non-negative, just do lseek

; net position would be negative, seek back to original location, then fail

	mov	cx,hiword	; original offset
	mov	dx,loword
	mov	ax,DOS_lseek shl 8 + 0 ; from beginning of file
	callos			; go back
	jmp	short negative

;
; seek to the specified location
; bx = file handle
;

doit:
	mov	dx,word ptr (pos) ; low(pos)
	mov	cx,word ptr (pos)+2 ; high(pos)
	mov	al,byte ptr (mthd) ; method
	callos	lseek		; move file ptr
	jc	errexit

	and	__osfile[bx],NOT FEOFLAG ; clear ^z flag if lseek succeeds

errexit:
	jmp	__dosretax


cEnd	nogen

sEnd
	end
