	page	,132
	title	read - read from file handle
;***
;read.asm - read from a file handle
;
;	Copyright (c) 1987-1992, Microsoft Corporation. All rights reserved.
;
;Purpose:
;	defines read() - read from a file handle
;
;*******************************************************************************

include version.inc
.xlist
include cmacros.inc
include msdos.inc
include defsegs.inc
include errno.inc
include cmsgs.inc
ifdef _QWIN
include stdlib.inc
endif
.list


ifndef _WINDOWS
	_DEBUGSCREEN equ 1		; debug screen swapping
endif


ifdef _DEBUGSCREEN
CrtDefSegs <dbdata>

sBegin	dbdata				;
	assumes ds,data 		; Used to do the running under
externW 	__aDBswpflg		; a debugger screen swapping
externW 	__aDBswpchk		;
sEnd	dbdata				;
	extrn	__aDBdoswp:ABS		;
endif	; _DEBUGSCREEN


sBegin	data

	assumes ds,data

extrn	__osfile:byte		; file handle flags, etc.
extrn	__nfile:word		; Maximum number of file handles

ifdef _QWIN
extrn	__wnfile:word		; Maximum file handles including QWIN files
extrn	__qwinused:word 	; QWIN used/notused flag
endif

sEnd


extrn	__dosretax:near

ifdef  _QWIN
externNP   _wread		; read from QWIN window handle
endif


sBegin	code

	assumes cs,code
	assumes ds,data
	assumes es,data

page
;***
;int _read(fh, buf, cnt) - read bytes from a file handle
;
;Purpose:
;	Attempts to read cnt bytes from fh into a buffer.
;	If the file is in text mode, CR-LF's are mapped to LF's, thus
;	affecting the number of characters read.  This does not
;	affect the file pointer.
;
;	NOTE:  The stdio _IOCTRLZ flag is tied to the use of FEOFLAG.
;	Cross-reference the two symbols before changing FEOFLAG's use.
;
;Entry:
;	int fh - file handle to read from
;	char *buf - buffer to read into
;	int cnt - number of bytes to read
;
;Exit:
;	Returns number of bytes read (may be less than the number requested
;	if the EOF was reached or the file is in text mode).
;	returns -1 (and sets errno) if fails.
;
;Uses:
;
;Exceptions:
;
;*******************************************************************************

cProc	_read,<PUBLIC>,<>

	parmW	fh
	parmDP	buf
	parmW	cnt
	localB	peekchr 	; temporary byte used for peek-ahead

cBegin

	; make sure handle is in range

	mov	bx,fh		; bx = file handle

ifdef _QWIN

	mov	ax,[__nfile]	; ax = max OS file handle
	cmp	[__qwinused],0	; QWIN system enabled ?
	je	test_fh 	; no, jump down
	mov	ax,[__wnfile]	; yes, use QWIN max file handle
	cmp	bx,_MAX_STDFH	; adjust stdin/out/err as necessary
	ja	test_fh
	mov	bx,[__nfile]	; yes, use QWIN std file
test_fh:
	cmp	bx,ax		; handle in range ?
	jb	fh_okay 	; yup, continue
	;fall thru		; no, error

else	;!_QWIN

	cmp	bx,[__nfile]	; handle in range ?
	jb	fh_okay 	; yes, continue

endif	;_QWIN


badfh:				; bad file handle
	stc
	mov	ax,EBADF shl 8 + 0 ; map all dos read errors to xenix EBADF
_readret:
ifdef _WINDOWS
	jmp	readret
else
	jmp	short readret
endif

fh_okay:
	xor	ax,ax		; assume 0 bytes read (also clears carry)

	mov	cx,cnt
ifdef _QWIN
	jcxz	_readret	; asking for zero bytes means do nothing
else
	jcxz	readret 	; asking for zero bytes means do nothing
endif

	test	__osfile[bx],FEOFLAG ; was eof (^Z) found in last read
ifdef _QWIN
	jnz	_readret	; yes, return 0 bytes read (eof)
else
	jnz	readret 	; yes, return 0 bytes read (eof)
endif

;
; Read from the file
; bx = handle
; cx = count
;
ifdef _DEBUGSCREEN
	cmp	__aDBswpflg,__aDBdoswp	;* Aware debugger as parent?
	jne	@F			;* No -- skip
	call	__aDBswpchk		;* Yes -- see if we need to swap screens
@@:
endif	; _DEBUGSCREEN


	mov	cx,cnt		; number of bytes to read

ifdef	_QWIN
	; *** Do this test before changing ds!
	cmp	bx,[__nfile]	; is this a QWIN or OS file handle ?
endif

if	sizeD
	push	ds
	lds	dx,buf		; buffer address
else
	mov	dx,buf		; buffer address
endif

ifdef	_QWIN
	;*** Counts on flags being preserved from "cmp bx,[__nfile]"
	jb	oscall1 	; is bx an QWIN or OS file handle ?
	call	_wread		; call QWIN
	jmp	short after1
oscall1:			; call OS
	callos	read
after1:
else	;!_QWIN
	callos	read
endif	;_QWIN

if	sizeD
	pop	ds
endif

	jnc	readok		; if no error

	mov	ah,EBADF	; map all dos read errors to xenix EBADF
	jmp	short readret	; error return

readok:
	test	__osfile[bx],FTEXT ; check if text mode
	jz	readret 	; no, just return
;
;	convert buffer to LF only form.  Also detects ^Z and sets an
;	end-of-file flag so that subsequent reads will not go past it.
;
; entry:
;	dx = buffer address
;	ax = count
;	bx = file handle
; returns:
;	ax = new count
;
	and	__osfile[bx],not FCRLF ; assume 1st byte in buffer is NOT a LF

	push	si
	push	di

if	sizeD
	push	ds		; save ds in es for __osfile ref. below
	pop	es
	mov	ds,word ptr (buf)+2 ; load new ds for buffer
endif

	cld
	mov	si,dx		; start at dx
	mov	di,dx
	mov	cx,ax		; cx = buffer size
	jcxz	cleanup 	; empty buffer, clean up and exit

	mov	ah,C_CR		; CR

	cmp	byte ptr ds:[si],C_LF ; check for LF at beginning of buffer
	jne	crloop
;
;	A line feed was found at the beginning of the read buffer.
;	Assume the last byte read in the previous read operation was a CR.
;
if	sizeD
	or	es:__osfile[bx],FCRLF
else
	or	__osfile[bx],FCRLF
endif

crloop:
	lodsb			; get next char
	cmp	al,ah		; is it CR ?
	je	havecr		; yes, look for CRLF pair

	cmp	al,C_SUB	; not CR, is it ^Z ?
	jne	storechr	; no, store it and move on

if	sizeD
	or	es:__osfile[bx],FEOFLAG ; set EOF indicator
else
	or	__osfile[bx],FEOFLAG ; set EOF indicator
endif
	jmp	short crdone	; return, don't store ^Z

storechr:
	mov	[di],al 	; store character
	inc	di		; increment destination pointer

nostore:
	loop	crloop		; loop

crdone:
	mov	ax,di
	sub	ax,dx		; ax = new count

cleanup:

if	sizeD
	push	es		; recover ds from es
	pop	ds
endif

crret:
	pop	di
	pop	si

readret:
	jmp	__dosretax	; return AX if successful

cEnd	<nogen> 		; NOT REACHED


havecr:

; we get here iff we have found a CR character in the input.  We will look
; ahead one character to see if it is an LF, if so, we store only the LF
; and go on; otherwise we store the CR and go on.  The only time this gets
; interesting is when the CR is discovered as the last character in the
; buffer, which means we have to read ahead.

	cmp	cx,1		; last char in buffer ?
	je	lookahead	; yes - read next char

	cmp	byte ptr [si],C_LF ; no, is next char in buffer an LF ?
	je	nostore 	; yes - skip CR

	jmp	short storechr	; no, CR only - save it

lookahead:
;
; we get here iff we have found a CR as the last character in the buffer.
;
if	sizeD
	push	es
	pop	ds		; restore regular ds for a while
endif
	test	__osfile[bx],FDEV ; is fh a device ?
	jz	nodev		; no, continue

ifdef	_QWIN
	cmp	bx,[__nfile]	; is this a QWIN handle ?
	jae	notraw		; yes, no DOS calls
	;*** Note: we count on flags being preserved for below! ***
endif	;_QWIN

	mov	ax,DOS_ioctl shl 8 + 0 ; get dev info
	callos
	test	dx,20H		; in raw mode ?
	jnz	retlf		; yes, don't do read-ahead
;
; There is an implied LF; read it
;

notraw:

if sizeD OR ?WIN
	push	ds		; save ds
	push	ss		; set ds = ss
	pop	ds
endif
	lea	dx,peekchr

ifdef	_QWIN
	;*** Counts on flags being preserved from "cmp bx,[__nfile]" above
	jb	oscall2 	; is this a QWIN or OS file handle ?
	call	_wread		; call QWIN
	jmp	short after2
oscall2:			; call OS
	callos	read
after2:
else	;!_QWIN
	callos	read		; read LF
endif	;_QWIN

if sizeD OR ?WIN
	pop	ds		; restore ds
endif

_crret:
	jc	crret		; error
retlf:
	mov	al,C_LF		; return LF
	jmp	short storeit	; clean up registers and store LF
nodev:
;
; Regular file, must do read ahead
;
ifdef _QWIN
; QWIN handles should never hit this code path!
endif

if sizeD OR ?WIN
	push	ds		; save ds
	push	ss		; set ds = ss
	pop	ds
endif
	mov	peekchr,0	; clear peekchr
	lea	dx,peekchr
	callos	read		; read next char
if sizeD OR ?WIN
	pop	ds		; restore ds
endif

ifdef _QWIN
	jc	_crret		; error (indirection cause jump out of range)
else
	jc	crret		; error
endif

	or	ax,ax		; end of file ?
	je	la_ret		; yes - save CR

	cmp	cnt,1		; only 1 byte requested ?
	je	bufsiz1 	; yes - act specially

seekback:
	mov	cx,-1		; no, move file pointer back 1
	mov	dx,cx
	mov	ax,DOS_lseek shl 8 + 1 ; lseek(fh, -1L, 1)
	callos

	mov	cx,1		; restore cx
	cmp	peekchr,C_LF	; was next char an LF ?

	je	dontstore	; yes - skip CR

la_ret:
	mov	al,C_CR		; no, restore CR to al

storeit:			; store character

if	sizeD
	lds	dx,buf		; reload buf pointer
else
	mov	dx,buf		; reload buf pointer
endif

ifdef _WINDOWS
	jmp	storechr	; save it
else
	jmp	short storechr	; save it
endif

dontstore:

if	sizeD
	lds	dx,buf		; reload buf pointer
else
	mov	dx,buf		; reload buf pointer
endif

ifdef _WINDOWS
	jmp	nostore 	; discard because the next byte is a LF
else
	jmp	short nostore	; discard because the next byte is a LF
endif

bufsiz1:
	cmp	peekchr,C_LF	; was next char an LF ?
	jne	seekback	; no  - seek back 1 char and store CR
	jmp	short retlf	; yes, store LF


sEnd

	end
