/***
*eof.c - test a handle for end of file
*
*   Copyright (c) 1985-1992, Microsoft Corporation. All rights reserved.
*
*Purpose:
*   defines eof() - determine if a file is at eof
*
*******************************************************************************/

#include <io.h>
#include <errno.h>
#include <stddef.h>
#include <stdio.h>
#include <internal.h>
#include <register.h>


/***
*int _eof(filedes) - test a file for eof
*
*Purpose:
*   see if the file length is the same as the present position. if so,
*   return 1. if not, return 0. if an error occurs, return -1
*
*Entry:
*   int filedes - handle of file to test
*
*Exit:
*   returns 1 if at eof
*   returns 0 if not at eof
*   returns -1 and sets errno if fails
*
*Exceptions:
*
*******************************************************************************/

int  _eof (filedes)
REG1 int filedes;
{
    long here;
    long end;
    REG2 int retval;

#ifdef _QWIN
    if (filedes < 0 || filedes >= (_qwinused ? _wnfile : _nfile) )
#else
    if (filedes < 0 || filedes >= _nfile)
#endif
    {
        errno = EBADF;
        return(-1);
    }

    /* Lock the file */

    /* See if the current position equals the end of the file. */

    if (  ((here = _lseek(filedes,0L,SEEK_CUR)) == -1L)
    || ((end = _lseek(filedes,0L,SEEK_END)) == -1L) )
        retval = -1;
    else if (here == end)
        retval = 1;
    else {
        _lseek(filedes,here,SEEK_SET);
        retval = 0;
    }

    /* Unlock the file */

    /* Done */
    return(retval);
}
