/***
*flength.c - find length of a file
*
*   Copyright (c) 1985-1992, Microsoft Corporation. All rights reserved.
*
*Purpose:
*   defines filelength() - find the length of a file
*
*******************************************************************************/

#include <stdio.h>
#include <register.h>
#include <errno.h>
#include <io.h>
#include <internal.h>
#include <stddef.h>


/***
*long _filelength(filedes) - find length of a file
*
*Purpose:
*   Returns the length in bytes of the specified file.
*
*Entry:
*   int filedes - handle referring to file to find length of
*
*Exit:
*   returns length of file in bytes
*   returns -1L if fails
*
*Exceptions:
*
*******************************************************************************/

long  _filelength (filedes)
REG1 int filedes;
{
    long length;
    long here;


#ifdef _QWIN
    if (filedes < 0 || filedes >= (_qwinused ? _wnfile : _nfile) )
#else
    if (filedes < 0 || filedes >= _nfile)
#endif
    {
        errno = EBADF;
        return(-1);
    }


    /* Seek to end to get length of file. */
    if ( (here = _lseek(filedes,0L,1)) == -1L)
        length = -1;    /* return error */
    else {
        length = _lseek(filedes,0L,2);
        if (here != length)
            _lseek(filedes,here,0);
    }


    return(length);
}
