	page	,132
	title	isatty - check if file is a device
;***
;isatty.asm - check if file handle refers to a device
;
;	Copyright (c) 1987-1992, Microsoft Corporation. All rights reserved.
;
;Purpose:
;	defines isatty() - check if file handle refers to a device
;
;*******************************************************************************

include version.inc
.xlist
include cmacros.inc
include msdos.inc
ifdef _QWIN
include stdlib.inc
endif
.list

sBegin	data
assumes ds,data

extrn	__osfile:byte
extrn	__nfile:word
ifdef _QWIN
extrn	__wnfile:word
extrn	__qwinused:word
else
endif

sEnd

sBegin	code

	assumes cs,code
	assumes ds,data

page
;***
;int _isatty(handle) - check if handle is a device
;
;Purpose:
;	Checks if the given handle is associated with a character device
;	(terminal, console, printer, serial port)
;
;Entry:
;	int handle - handle of file to be tested
;
;Exit:
;	returns non-0 if handle refers to character device,
;	returns 0 otherwise
;
;Uses:
;
;Exceptions:
;
;*******************************************************************************

cProc	_isatty,<PUBLIC>,<>

	parmw	fh

cBegin

ifdef	_LOAD_DGROUP
	push	ds
	mov	ax, DGROUP
	mov	ds, ax
endif	;_LOAD_DGROUP

	xor	ax,ax			; assume 0 return for now
	mov	bx,fh			; store file handle
ifdef _QWIN
	mov	cx,__nfile		; assume QWIN not enabled
	cmp	[__qwinused],0		; is QWIN enabled ?
	je	test_fh 		; no, do compare
	mov	cx,__wnfile		; yes, use _nfile
	cmp	bx,_MAX_STDFH		; handle = stdin/out/err ?
	ja	test_fh 		; nope, jump down
	mov	bx,[__nfile]		; yes, use QWIN std file
test_fh:
	cmp	bx,cx			; is fh < (_qwinused ? _wnfile : _nfile)
else
	cmp	bx,__nfile		; is fh < _nfile ?
endif
	jae	isattyexit		;   no
	test	__osfile[bx],FDEV	; test for device bit set
	jz	isattyexit		;   no
	inc	ax			;   yes - return 1

isattyexit:

ifdef _LOAD_DGROUP
	pop	ds
endif	;_LOAD_DGROUP

cEnd	<nolocals>

sEnd
	end
