/***
*mktemp.c - create a unique file name
*
*   Copyright (c) 1985-1992, Microsoft Corporation. All rights reserved.
*
*Purpose:
*   defines mktemp() - create a unique file name
*
*******************************************************************************/

#include <register.h>
#include <errno.h>
#include <assert.h>
#include <io.h>
#include <process.h>
#include <stddef.h>
#include <sizeptr.h>
#include <mbctype.h>
#include <mbdata.h>

/***
*char *_mktemp(template) - create a unique file name
*
*Purpose:
*   given a template of the form "fnamXXXXXX", insert number on end
*   of template, insert unique letter if needed until unique filename
*   found or run out of letters
*
*Entry:
*   char *template - template of form "fnamXXXXXX"
*
*Exit:
*   return pointer to modifed template
*   returns NULL if template malformed or no more unique names
*
*Exceptions:
*
*******************************************************************************/

char *  _mktemp (template)
char *template;
{
#ifdef SIZED
    REG3 char *string = template;
    REG1 unsigned number;
#else
    REG1 char *string = template;
    REG3 unsigned number;
#endif
    int letter = 'a';
    REG2 int xcount = 0;
    int olderrno;

    assert(template != NULL);
    assert(*template != '\0');

    number = _getpid();

    while (*string)
        string++;

#ifdef _MBCS
    while (!_ISLEADBYTE(*(string - 2)) && *--string == 'X')
#else
    while (*--string == 'X')
#endif
    {
        xcount++;
        *string = (char)((number % 10) + '0');
        number /= 10;
    }

    if (*++string == '\0' || xcount != 6 )
        return(NULL);

    olderrno = errno;   /* save current errno */
    errno = 0;  /* make sure errno isn't EACCESS */

    while ((_access(template,0) == 0) || (errno == EACCES))
        /* while file exists */
    {
        errno = 0;
        if (letter == 'z'+1) {
            errno = olderrno;
            return(NULL);
        }

        *string = (char)letter++;
    }

    errno = olderrno;
    return(template);
}
