/***
*setmode.c - set file translation mode
*
*   Copyright (c) 1985-1992, Microsoft Corporation. All rights reserved.
*
*Purpose:
*   defined setmode() - set file translation mode of a file
*
*******************************************************************************/

#include <io.h>
#include <stdio.h>
#include <fcntl.h>
#include <errno.h>
#include <register.h>
#include <msdos.h>
#include <stddef.h>
#include <internal.h>


/***
*int _setmode(fh, mode) - set file translation mode
*
*Purpose:
*   changes file mode to text/binary, depending on mode arg. this affects
*   whether read's and write's on the file translate between CRLF and LF
*   or is untranslated
*
*Entry:
*   int fh   - file handle to change mode on
*   int mode - file translation mode (one of _O_TEXT and _O_BINARY)
*
*Exit:
*   returns old file translation mode
*   returns -1 and sets errno if fails
*
*Exceptions:
*
*******************************************************************************/


int  _setmode (fh, mode)
REG1 int fh;
int mode;
{
    int oldmode;

#ifdef _QWIN
    if (fh < 0 || fh >= (_qwinused ? _wnfile : _nfile) )
#else
    if (fh < 0 || fh >= _nfile)
#endif
    {
        errno = EBADF;
        return(-1);
    }


    if (!(_osfile[fh] & FOPEN)) {
        errno = EBADF;
        return(-1);
    }

    else {
        oldmode = _osfile[fh] & FTEXT;

        if (mode == _O_BINARY)
            _osfile[fh] &= ~FTEXT;
        else if (mode == _O_TEXT)
            _osfile[fh] |= FTEXT;
        else    {
            errno = EINVAL;
            return(-1);
        }
    }

    return(oldmode ? _O_TEXT : _O_BINARY);

}
