	page	,132
	title	wabout - Windows Set About String
;***
;wabout.asm - Windows Set About String
;
;	Copyright (c) 1990-1992, Microsoft Corporation.  All rights reserved.
;
;Purpose:
;	Set the "About" string in a windows app.
;
;	This routine is in it's own source so it can be stubbed out
;	by programs that don't want the QWIN functionality.
;
;*******************************************************************************

include version.inc
.xlist
include cmacros.inc
.list

ifndef _QWIN
	%err
	%out ! ERROR - For use with _QWIN only!!!
endif

externFP   _QWINSetAboutString	; QWIN call


sBegin	code

	assumes cs,code
	assumes ds,data

page
;***
; _wabout - Set "About" string in windows EXE
;
;Purpose:
;
;	This routine calls the QWIN layer to set up the
;	"About" string for the app.
;
;Entry:
;	char * str = Pointer to null terminated about string
;
;Exit:
;
;	int =  0 = success
;	      !0 = failure
;Uses:
;
;Exceptions:
;
;*******************************************************************************

cProc	_wabout,<PUBLIC>,<>

	parmDP	string		; ptr to user string

cBegin	<nolocals>

;
; Let QWIN layer do all the work!
;
	; _QWINSetAboutString (char * string)

if sizeD
	les	ax,[string]		 ; es:ax = * string
	push	es
	push	ax
else
	mov	ax,[string]		 ; ds:ax = * string
	push	ds
	push	ax
endif
	call	_QWINSetAboutString	; set the "About" string
	add	sp,4			; clean stack

	; ax is set correctly for return

cEnd	<nolocals>

sEnd
	End
