	page	,132
	title	wclose - Windows Close
;***
;wclose.asm - Windows Close
;
;	Copyright (c) 1990-1992, Microsoft Corporation.  All rights reserved.
;
;Purpose:
;	Close QWIN window handle.
;
;*******************************************************************************

include version.inc
.xlist
include cmacros.inc
include errno.inc
include rterr.inc
.list

ifndef _QWIN
	%err
	%out ! ERROR - For use with _QWIN only!!!
endif

;
; Externals
;

externFP	_QWINClose	; QWIN close call

externNP	_amsg_exit	; fatal termination


sBegin	data
assumes ds,data

externW 	errno		; error code
externB 	_osfile 	; lowio file handle flags, etc.
externW 	_nfile		; number of OS files
externW 	_wnfile 	; number of total files (QWIN and OS)

sEnd



sBegin	code

	assumes cs,code
	assumes ds,data

page
;***
; _wclose - Close a lowio QWIN window file handle
;
;Purpose:
;	Close a lowio QWIN window file handle
;
;	Note:  If the user selects "persist".  We do NOT zero out
;	the _osfile[] entry.  This is because the user may later
;	come back close the file again, this time without persist.
;	We don't keep track of this.  Rather, it's up to the user
;	to remember that the file is closed and s/he shouldn't do
;	any I/O to that handle.
;
;Entry:
;	int fh = handle to close
;	int persist = whether the window should persist or not
;		0 = do not persist, close window
;		1 = persist, keep window around
;
;Exit:
;	0 = success
;	-1 = error
;Uses:
;
;Exceptions:
;
;*******************************************************************************

cProc	_wclose,<PUBLIC>,<>

	parmW	fh		; file handle
	parmW	persist 	; persist flag

cBegin	<nolocals>

;
; Validate file handle
;
	mov	bx,[fh] 	; bx = file handle
	cmp	bx,[_wnfile]	; >= _wnfile ??
	jae	error1		; yes, bad handle
	cmp	bx,[_nfile]	; < _nfile ??
	jnb	fh_ok		; nope, handle is ok
	;fall thru		; yes, error

	;*** illegal to close stdin/out/err ***

;
; --- Error returns ---
;

error1:
	mov	[_errno],EBADF	; bad file handle
	mov	ax,-1		; ax = -1 = error
	jmp	short done	; join return code

;
; Close the window
; bx = file handle
;
fh_ok:
	; _QWINClose( fh, persist )
	mov	ax,[persist]
	push	ax			; persist flag
	push	bx			; file handle
	call	_QWINClose		; Close window
	pop	bx			; bx = file handle
	pop	cx			; cx = persist flag
	or	ax,ax			; error ??
	jnz	error1

;
; Clear _osfile[] entry, "no persist" option
; ax = 0
; bx = file handle
; cx = persist flag
;
	or	cx,cx			; persist ??
	jnz	done			; yes, all done
	mov	__osfile[bx],al 	; nope, clean out file
;
; --- Good Return
; ax = 0
;

done:
cEnd	<nolocals>

;
; --- Fatal Error ---
;

fatal_err:
	mov	ax,_RT_QWIN	; QuickWin error
	jmp	_amsg_exit	; die


IF 0	;**** ROUTINE NOT CURRENTLY NEEDED ***
page
;***
; _wdosclose - Close an QWIN file
;
;Purpose:
;	This routine calls the QWIN file close routine.  The interface
;	emulates the DOS close file handle system call (0x3E).
;
;	Note:  The _QWINClose call allows the caller to specify whether
;	the window should persist or not after it is closed to I/O
;	(Persistence allows the user to persuse the window).   This
;	routines always closes with NO persistence.
;
;Entry:
;	(same as DOS close system call)
;
;	bx = file handle
;	ds = DGROUP
;
;	[Note:	It is assumed bx is a valid QWIN handle.  This routine
;	does not check.]
;
;Exit:
;	(same as DOS close system call)
;
;	Success:
;		Carry clear
;
;	Failure:
;		Carry set
;		ax = error code
;
;Uses:
;
;Exceptions:
;
;*******************************************************************************

cProc	_wdosclose,<PUBLIC,NEAR>,<bx,cx,dx>

cBegin	<nolocals>

	; _QWINClose( fh, no_persist )
	xor	ax,ax
	push	ax			; 0 = no persist
	push	bx			; file handle
	call	_QWINClose		; Close window
	add	sp,4
	or	ax,ax			; error ??
	;clc				; !!! OR clears carry !!!
	jz	done			; jump if not

	mov	ax,ERROR_INVALID_HANDLE ; set error code
	stc				; set carry
done:

cEnd	<nolocals>

ENDIF	;***


sEnd
	End
