	page	,132
	title	wgetbuf - Get window screen buffer size
;***
;wgetbuf.asm - Get window screen buffer size
;
;	Copyright (c) 1990-1992, Microsoft Corporation.  All rights reserved.
;
;Purpose:
;	Get window screen buffer size.
;
;*******************************************************************************

include version.inc
.xlist
include cmacros.inc
include errno.inc
include stdlib.inc
.list

ifndef _QWIN
	%err
	%out ! ERROR - For use with _QWIN only!!!
endif

;
; Externals
;

externFP	_QWINGetBuffSize ; QWIN get buffer size

;
; Data
;

sBegin	data
assumes ds,data

externW 	errno		; error code
externW 	_nfile		; first QWIN file handle

sEnd


sBegin	code
	assumes cs,code
	assumes ds,data

page
;***
; _wgetscreenbuf - Get window screen buffer size
;
;Purpose:
;	Get the buffer size of an open QWIN window file.
;
;Entry:
;	int fh = handle
;
;Exit:
;	Success = Size of buffer
;	Error = -1
;
;Uses:
;
;Exceptions:
;
;	We don't verify that the QWIN layer is in use.
;	If the user has stubbed it out, then this routine will
;	die with a fatal error.
;
;*******************************************************************************

cProc	_wgetscreenbuf,<PUBLIC>,<>

	parmW	fh		; file handle

cBegin	<nolocals>

;
; Get file handle and modify if stdin/out/err
;

	mov	bx,[fh] 		; bx = file handle
	cmp	bx,_MAX_STDFH		; adjust stdin/out/err as necessary
	ja	@F
	mov	bx,[_nfile]		; yes, use QWIN std file
@@:

;
; Pass the values directly to the QWIN layer
; [Note: We do not validate the file handle but rather let
; QWIN layer do this for us.]
;
	; _QWINGetBuffSize (fh)

	push	bx			; file handle
	call	_QWINGetBuffSize	; Get the buffer size
	pop	bx			; clean off stack
	; fall thru

;
; dx:ax = return value
;

done:

cEnd	<nolocals>

sEnd
	End
