/***
*wgetexit.c - Get QuickWin Exit Setting
*
*   Copyright (c) 1990-1992, Microsoft Corporation.  All rights reserved.
*
*Purpose:
*   Get QuickWin Exit Setting
*
*******************************************************************************/

#include <windows.h>
#include <qwin.h>
#include <io.h>


/***
*_wgetexit() -  Get QuickWin Exit Setting
*
*Purpose:
*   This routine returns the current QuickWin exit setting
*   which determines what the app does when the exit() procedure
*   is called.  The return values are:
*
*   _WINEXITPROMPT      // prompt user to persist or not
*   _WINEXITNOPERSIST   // clear output and terminate
*   _WINEXITPERSIST     // keep output on screen and let user browse
*
*Entry:
*   void
*
*Exit:
*   One of the constants listed above.
*
*Exceptions:
*
*******************************************************************************/

int  _wgetexit (void)
{

    return(_QWINGetExit());

}
