	page	,132
	title	wgetfoc - Get window focus
;***
;wgetfoc.asm - Get window focus
;
;	Copyright (c) 1990-1992, Microsoft Corporation.  All rights reserved.
;
;Purpose:
;	Get the window that has focus.
;
;*******************************************************************************

include version.inc
.xlist
include cmacros.inc
include errno.inc
include stdlib.inc
.list

ifndef _QWIN
	%err
	%out ! ERROR - For use with _QWIN only!!!
endif

;
; Externals
;

externFP	_QWINGetFocus	; QWIN get focus

;
; Data
;

sBegin	data
assumes ds,data

externW 	errno		; error code
externW 	_nfile		; first QWIN file handle

sEnd


sBegin	code
	assumes cs,code
	assumes ds,data

page
;***
; _wgetfocus - Get window focus
;
;Purpose:
;	Get the handle of the window that has focus for the
;	process' QWIN frame.
;
;Entry:
;	<void>
;
;Exit:
;	Success = file handle
;	Error = -1
;Uses:
;
;Exceptions:
;
;	We don't verify that the QWIN layer is in use.
;	If the user has stubbed it out, then this routine will
;	die with a fatal error.
;
;*******************************************************************************

cProc	_wgetfocus,<PUBLIC>,<>

cBegin	<nolocals>

;
; Issue the QWIN call.
; [Note: We do not validate the file handle but rather let
; QWIN layer do this for us.]
;
	; _QWINGetFocus (void)

	call	_QWINGetFocus		; Get the focus

;
; Modify return value if stdin/out/err.
; [Note:  Since all std file handles map to a single QWIN handle,
; there is some ambiguity on reversing the translation; we
; arbitrarily map to stdout.]
;
; ax = QWIN handle or -1 for error
;

	cmp	ax,[_nfile]		; stdin/out/err QWIN handle ?
	jne	@F			; no, just return
	mov	ax,1			; yes, return stdout
@@:

;
; ax = return value (fh or -1)
;

done:

cEnd	<nolocals>

sEnd
	End
