	page	,132
	title	wmenuclk - Click on a menu item
;***
;wmenuclk.asm - Click on a menu item
;
;	Copyright (c) 1990-1992, Microsoft Corporation.  All rights reserved.
;
;Purpose:
;	Click on a menu item.
;
;*******************************************************************************

include version.inc
.xlist
include cmacros.inc
include errno.inc
.list

ifndef _QWIN
	%err
	%out ! ERROR - For use with _QWIN only!!!
endif

;
; Externals
;

externFP	_QWINMenuClick	; QWIN menu click

;
; Data
;

sBegin	data
assumes ds,data

externW 	errno		; error code

sEnd


sBegin	code
	assumes cs,code
	assumes ds,data

page
;***
; _wmenuclick - Click on a menu item
;
;Purpose:
;	Click on a QWIN menu item.
;
;Entry:
;	int menuid = id of menu item being clicked on
;
;Exit:
;	Success = 0
;	Error = -1
;Uses:
;
;Exceptions:
;
;	We don't verify that the QWIN layer is in use.
;	If the user has stubbed it out, then this routine will
;	die with a fatal error.
;
;*******************************************************************************

cProc	_wmenuclick,<PUBLIC>,<>

	parmW	menuid		; id of menu item

cBegin	<nolocals>

;
; Pass the value directly to the QWIN layer
; [Note: We do not validate the file handle but rather let
; QWIN layer do this for us.]
;
	; _QWINSetFocus (fh)

	mov	bx,[menuid]		; get the menu id
	push	bx			; push it
	call	_QWINMenuClick		; Set the focus
	pop	bx			; clean off stack
	;fall thru

;
; ax = return value (0 or -1)
;

done:

cEnd	<nolocals>

sEnd
	End
