	page	,132
	title	wopen - Windows Open
;***
;wopen.asm - Windows Open
;
;	Copyright (c) 1990-1992, Microsoft Corporation.  All rights reserved.
;
;Purpose:
;	Open an QWIN window file.
;
;*******************************************************************************

include version.inc
.xlist
include cmacros.inc
include errno.inc
include fcntl.inc
include msdos.inc
include rterr.inc
.list

ifndef _QWIN
	%err
	%out ! ERROR - For use with _QWIN only!!!
endif

;
; Externals
;

externFP	_QWINOpen	; Open QWIN windows

externNP	_amsg_exit	; fatal termination

;
; Data
;

sBegin	data
assumes ds,data

externW 	errno		; error code
externW 	_fmode		; default text/binary mode flag
externB 	_osfile 	; lowio file handle flags, etc.
externW 	_nfile		; number of OS files
externW 	_wnfile 	; number of total files (QWIN and OS)

sEnd


sBegin	code

	assumes cs,code
	assumes ds,data

page
;***
; _wopen - Open a lowio QWIN window file handle
;
;Purpose:
;	Opens a QWIN window file.
;
;Entry:
;	struct * _wopeninfo = pointer to QWIN open structure
;	struct * _wsizeinfo = pointer to QWIN size structure, may be NULL
;	int oflag = type of operations allowed
;
;Exit:
;	int fh = file handle
;	    -1 = error
;Uses:
;
;Exceptions:
;
;*******************************************************************************

cProc	_wopen,<PUBLIC>,<>

	parmDP	wopeninfo	; pointer to _wopeninfo structure
	parmDP	wsizeinfo	; pointer to _wsizeinfo structure
	parmW	oflag		; open flags

	localW	handle		; new file handle
	localB	osflags 	; _osfile[] flags

cBegin

;
; validate and save input flags
;
;	O_RDONLY, O_WRONLY, O_RDWR = Must specify 1 and only 1
;	O_BINARY, O_TEXT = Use specification or default
;	O_APPEND = Superfluous, ignore it
;	O_CREATE, O_EXCL, O_TRUNC = Illegal for QWIN window files
;

	mov	bx,[oflag]		; get input flags
	test	bx,(O_CREAT+O_EXCL+O_TRUNC) ; any bogus flags ??
	jnz	error1			; error, if any set

	; al = cumulative _osfile[] value
	mov	al,(FOPEN+FDEV) 	; always FOPEN and FDEV

	; set text/binary flag
	test	bx,O_BINARY		; explicit binary mode ?
	jnz	not_text		; yes, binary mode
	test	bx,O_TEXT		; explicit text mode ?
	jnz	text			; yes, text mode
	test	[_fmode],O_BINARY	; default = binary ??
	jnz	not_text		; yes, binary mode
text:
	or	al,FTEXT		; text mode
not_text:

	; set read/write flags
	; [Note: mildly wierd because O_RDONLY is 0 (i.e., no bit!).]
	xor	cl,cl			; cl = counter = 0
	test	bx,O_RDWR		; read/write specified ?
	jz	@F			; nope, jump down
	inc	cl			; bump counter
@@:	test	bx,O_WRONLY		; write only ?
	jz	@F			; nope, jump down
	inc	cl			; bump counter
@@:	cmp	cl,1			; counter = 1 ??
	je	flags_ok		; 1, all set
	ja	error1			; >1, error -- too many flags set
	or	al,FRDONLY		; 0 = assume readonly
	jmp	short flags_ok		; flags ok

;
; --- Error returns ---
;

error1:
	mov	bx,EINVAL		; bad flags value
	jmp	short errrtn
error2:
	mov	bx,EMFILE		; no more handles available
	;jmp	short errrtn
errrtn:
	mov	[_errno],bx		; set errno
	mov	ax,-1			; ax = -1 = error
	jmp	short done		; join return code

;
; Open flags are fine
; al = _osfile flags
;

flags_ok:
	mov	[osflags],al		; save for later

;
; Open the window file handle
;
	; _QWINOpen ( (far *) _wopeninfo, (far *) _wsizeinfo )

if sizeD
	les	ax,[wsizeinfo]		; es:ax = *_wsizeinfo
	push	es
	push	ax
	les	ax,[wopeninfo]		; es:ax = *_wopeninfo
	push	es
	push	ax
else
	;wsizeinfo pointer may be NULL, expand to far pointer correctly
	xor	ax,ax			; ax = 0
	mov	cx,[wsizeinfo]		; cx = *_wsizeinfo
	jcxz	@F			; NULL ??
	mov	ax,ds			; ax:cx = (far *) _wsizeinfo
@@:
	push	ax
	push	cx

	mov	ax,[wopeninfo]		; ds:ax = *_wopeninfo
	push	ds
	push	ax
endif
	call	_QWINOpen
	add	sp,8
	cmp	ax,-1			; ax = file handle
	je	error2

	; make sure the handle is in our expected range
	cmp	ax,[_nfile]		; < _nfile ??
	jb	fatal_err		; oops.
	cmp	ax,[_wnfile]		; >= _wnfile ??
	jae	fatal_err		; oops.

;
; Set _osfile[] entry
; ax = new handle
;
	mov	bx,ax			; bx = handle
	mov	cl,[osflags]		; al = _osfile flags
	mov	_osfile[bx],cl		; set flags

;
; --- Good return ---
; bx = handle
;
	mov	ax,bx			; ax = new handle
	;jmp	short done

done:
cEnd

;
; --- Fatal Error ---
;

fatal_err:
	mov	ax,_RT_QWIN	; QuickWin error
	jmp	_amsg_exit	; die


IF 0	;**** ROUTINE NOT CURRENTLY NEEDED ***
page
;***
; _wdosopen - Open an QWIN file
;
;Purpose:
;	This routine calls the QWIN file open routine.	The interface
;	emulates the DOS open file handle system call (0x3D).
;
;	*** THIS CODE HAS NOT BEEN KEPT UP TO DATE WITH THE
:	*** CHANGING _QWINOPEN() INTERFACE.
;
;Entry:
;	(same as DOS open system call)
;
;	al = access code
;	ds:dx = pointer to file name
;
;Exit:
;	(same as DOS open system call)
;
;	Success:
;		Carry clear
;		ax = file handle
;
;	Failure:
;		Carry set
;		ax = error code
;
;Uses:
;
;Exceptions:
;
;*******************************************************************************

cProc	_wdosopen,<PUBLIC,NEAR>,<bx,cx,dx>

cBegin	<nolocals>

if sizeD
	push	ds			; save original ds
endif

	; _QWINOpen( (char far *) filename )
	push	ds			; filename segment
	push	dx			; filename offset
if sizeD
	call	__GetDGROUP
	mov	ds,ax			; set DS = DGROUP
endif
	call	_QWINOpen		; Open from the window
	add	sp,4
	cmp	ax,-1			; error ??
	clc				; assume success
	jne	done			; jump if not

	mov	ax,ERROR_INVALID_HANDLE ; set error code
	stc				; set carry
done:

if sizeD
	pop	ds
endif

cEnd	<nolocals>

ENDIF	;***


sEnd
	End
