	page	,132
	title	wsetbuf - Set windows screen buffer size
;***
;wsetbuf.asm - Set windows screen buffer size
;
;	Copyright (c) 1990-1992, Microsoft Corporation.  All rights reserved.
;
;Purpose:
;	Set windows screen buffer size.
;
;*******************************************************************************

include version.inc
.xlist
include cmacros.inc
include errno.inc
include stdlib.inc
.list

ifndef _QWIN
	%err
	%out ! ERROR - For use with _QWIN only!!!
endif

;
; Externals
;

externFP	_QWINSetBuffSize ; QWIN set buffer size

;
; Data
;

sBegin	data
assumes ds,data

externW 	errno		; error code
externW 	_nfile		; first QWIN file handle

sEnd


sBegin	code
	assumes cs,code
	assumes ds,data

page
;***
; _wsetscreenbuf - Set windows screen buffer size
;
;Purpose:
;	Set the buffer size of an open QWIN window file.
;
;Entry:
;	int fh = handle
;	int wbufsize = size of screen buffer.  User may set size
;		       or use one of the following constants:
;
;			_WBUFDEF = Default size
;			_WBUFINF = Infinate size
;
;Exit:
;	Success = 0
;	Error = -1
;Uses:
;
;Exceptions:
;
;	We don't verify that the QWIN layer is in use.
;	If the user has stubbed it out, then this routine will
;	die with a fatal error.
;
;*******************************************************************************

cProc	_wsetscreenbuf,<PUBLIC>,<>

	parmW	fh		; file handle
	parmD	wbufsiz 	; size of buffer

cBegin	<nolocals>

;
; Get file handle and modify if stdin/out/err
;

	mov	bx,[fh] 		; bx = file handle
	cmp	bx,_MAX_STDFH		; adjust stdin/out/err as necessary
	ja	@F
	mov	bx,[_nfile]		; yes, use QWIN std file
@@:

;
; Pass the values directly to the QWIN layer
; [Note: We do not validate the file handle but rather let
; QWIN layer do this for us.]
;
	; _QWINSetBuffSize (fh, wbufsiz)

	mov	dx,word ptr [wbufsiz+2]
	mov	ax,word ptr [wbufsiz]	; dx:ax = screen buffer size
	push	dx			; screen buffer size
	push	ax
	push	bx			; file handle
	call	_QWINSetBuffSize	; Set the buffer size
	add	sp,6
	;fall thru

;
; ax = return value (0 or -1)
;

done:

cEnd	<nolocals>

sEnd
	End
