/***
*wsetexit.c - Set QuickWin Exit Setting
*
*   Copyright (c) 1990-1992, Microsoft Corporation.  All rights reserved.
*
*Purpose:
*   Set QuickWin Exit Setting
*
*******************************************************************************/

#include <windows.h>
#include <qwin.h>
#include <io.h>


/***
*_wsetexit() -  Set QuickWin Exit Setting
*
*Purpose:
*   This routine indicates how a QuickWin app should behave
*   when the exit() procedure is called.
*   The input options are :
*
*   _WINEXITPROMPT      // prompt user to persist or not
*   _WINEXITNOPERSIST   // clear output and terminate
*   _WINEXITPERSIST     // keep output on screen and let user browse
*
*Entry:
*   One of the manifest constants listed above.
*
*Exit:
*   0 = success
*   -1 = failure
*
*Exceptions:
*
*******************************************************************************/

int  _wsetexit (exitcode)
int exitcode;
{

    return(_QWINSetExit(exitcode));

}
