	page	,132
	title	wsetfoc - Set window focus
;***
;wsetfoc.asm - Set window focus
;
;	Copyright (c) 1990-1992, Microsoft Corporation.  All rights reserved.
;
;Purpose:
;	Set window focus.
;
;*******************************************************************************

include version.inc
.xlist
include cmacros.inc
include errno.inc
include stdlib.inc
.list

ifndef _QWIN
	%err
	%out ! ERROR - For use with _QWIN only!!!
endif

;
; Externals
;

externFP	_QWINSetFocus	; QWIN set focus

;
; Data
;

sBegin	data
assumes ds,data

externW 	errno		; error code
externW 	_nfile		; first QWIN file handle

sEnd


sBegin	code
	assumes cs,code
	assumes ds,data

page
;***
; _wsetfocus - Set window focus
;
;Purpose:
;	Set the focus for the process' QWIN frame to the specified
;	window.
;
;Entry:
;	int fh = handle
;
;Exit:
;	Success = 0
;	Error = -1
;Uses:
;
;Exceptions:
;
;	We don't verify that the QWIN layer is in use.
;	If the user has stubbed it out, then this routine will
;	die with a fatal error.
;
;*******************************************************************************

cProc	_wsetfocus,<PUBLIC>,<>

	parmW	fh		; file handle
	parmD	wbufsiz 	; size of buffer

cBegin	<nolocals>

;
; Get file handle and modify if stdin/out/err
;

	mov	bx,[fh] 		; bx = file handle
	cmp	bx,_MAX_STDFH		; adjust stdin/out/err as necessary
	ja	@F
	mov	bx,[_nfile]		; yes, use QWIN std file
@@:

;
; Pass the values directly to the QWIN layer
; [Note: We do not validate the file handle but rather let
; QWIN layer do this for us.]
;
	; _QWINSetFocus (fh)

	push	bx			; file handle
	call	_QWINSetFocus		; Set the focus
	pop	bx			; clean off stack
	;fall thru

;
; ax = return value (0 or -1)
;

done:

cEnd	<nolocals>

sEnd
	End
