	page	,132
	title	wsetsize - Set window size and position
;***
;wsetsize.asm - Set window window size and position
;
;	Copyright (c) 1990-1992, Microsoft Corporation.  All rights reserved.
;
;Purpose:
;	Set window size and position
;
;*******************************************************************************

include version.inc
.xlist
include cmacros.inc
include errno.inc
include stdlib.inc
.list

ifndef _QWIN
	%err
	%out ! ERROR - For use with _QWIN only!!!
endif

;
; Externals
;

externFP	_QWINSetSize	; Set windows size/position

;
; Data
;

sBegin	data
assumes ds,data

externW 	errno		; error code
externW 	_nfile		; first QWIN file handle

sEnd


sBegin	code
	assumes cs,code
	assumes ds,data

page
;***
; _wsetsize - Set window size and position
;
;Purpose:
;	This call sets the size and position of an
;	open QWIN window file.
;
;Entry:
;	int fh = handle
;	struct * wsizeinfo = pointer to windows size/move structure
;
;Exit:
;	Success = 0
;	Error = -1
;Uses:
;
;Exceptions:
;
;	We don't verify that the QWIN layer is in use.
;	If the user has stubbed it out, then this routine will
;	die with a fatal error.
;
;*******************************************************************************

cProc	_wsetsize,<PUBLIC>,<>

	parmW	fh		; file handle
	parmDP	wsizeinfo	; pointer to _wsizeinfo structure

cBegin	<nolocals>

;
; Get file handle and modify if stdin/out/err
;

	mov	bx,[fh] 		; bx = file handle
	cmp	bx,_MAX_STDFH		; adjust stdin/out/err as necessary
	ja	@F
	mov	bx,[_nfile]		; yes, use QWIN std file
@@:

;
; Pass the values directly to the QWIN layer
; [Note: We do not validate the file handle but rather let
; QWIN layer do this for us.]
;
	; _QWINSetSize(fh, (far *) _wsizeinfo)

if sizeD
	les	ax,[wsizeinfo]		; es:ax = *wsizeinfo
	push	es
	push	ax
else
	mov	ax,[wsizeinfo]		; ds:ax = *wsizeinfo
	push	ds
	push	ax
endif
	push	bx			; file handle
	call	_QWINSetSize		; get size/position
	add	sp,6			; clear off stack

;
; ax = return value (0 or -1)
;

done:

cEnd	<nolocals>

sEnd
	End
