	page	,132
	title	wwrite - Windows Write
;***
;wwrite.asm - Windows Write
;
;	Copyright (c) 1990-1992, Microsoft Corporation.  All rights reserved.
;
;Purpose:
;	Write to the QWIN windows layer.
;
;	This routine is in it's own source so it can be stubbed out
;	by programs that don't want the QWIN functionality.
;
;*******************************************************************************

include version.inc
.xlist
include cmacros.inc
include error.inc
.list

ifndef _QWIN
	%err
	%out ! ERROR - For use with _QWIN only!!!
endif

externP    _GetDGROUP		; Function to recover DGROUP
externFP   _QWINWrite		; QWIN write call


sBegin	code

	assumes cs,code
	assumes ds,data

page
;***
; _wwrite - Write from an QWIN file
;
;Purpose:
;	This routine calls the QWIN file write routine.  The interface
;	emulates the DOS write file handle system call (0x40).
;
;Entry:
;	(same as DOS write system call)
;
;	bx = file handle
;	cx = byte count
;	ds:dx = buffer address
;
;	[Note:	It is assumed bx is a valid QWIN handle.  This routine
;	does not check.]
;
;Exit:
;	(same as DOS write system call)
;
;	Success:
;		Carry clear
;		ax = bytes written
;
;	Failure:
;		Carry set
;		ax = error code
;
;Uses:
;
;Exceptions:
;
;*******************************************************************************

cProc	_wwrite,<PUBLIC,NEAR>,<bx,cx,dx,es>

cBegin	<nolocals>

if sizeD
	push	ds			; save original ds
endif

	; _QWINWrite( (char far *) buf, count, fh, 0 )
	xor	ax,ax
	push	ax			; reserved (must be 0)
	push	bx			; file handle
	push	cx			; byte count
	push	ds			; buffer segment
	push	dx			; buffer offset
if sizeD
	call	__GetDGROUP
	mov	ds,ax			; set DS = DGROUP
endif
	call	_QWINWrite		; write from the window
	add	sp,10
	cmp	ax,-1			; error ??
	clc				; assume success
	jne	done			; jump if not

	mov	ax,ERROR_INVALID_HANDLE ; set error code
	stc				; set carry
done:

if sizeD
	pop	ds
endif

cEnd	<nolocals>


sEnd
	end
