	page	,132
	title	write - write to file handle
;***
;write.asm - write to a file handle
;
;	Copyright (c) 1987-1992, Microsoft Corporation. All rights reserved.
;
;Purpose:
;	defines write() - write to a file handle
;
;*******************************************************************************

.xlist
include version.inc
include cmacros.inc
include msdos.inc
include defsegs.inc
include errno.inc
include cmsgs.inc
ifdef _QWIN
include stdlib.inc
endif
.list

ifndef _WINDOWS
	_DEBUGSCREEN equ 1	; debug screen swapping
endif

IFDEF _WINDLL
STACK_UNKNOWN	EQU 1		; no known stack in windows dll
ENDIF

LFBUFFMIN EQU	128		; Min acceptable LF buffer length
LFBUFFMAX EQU	512		; Max LF buffer size
STACKSAVE EQU	40		; Space saved on stack



sBegin	data

	assumes ds,data

extrn	__osfile:byte		; file handle flags, etc.
extrn	__nfile:word		; Maximum number of file handles

ifdef _QWIN
extrn	__wnfile:word		; Maximum file handles including QWIN files
extrn	__qwinused:word 	; QWIN used/notused flag
endif


sEnd


ifdef _DEBUGSCREEN
;
;	The following segment and variables are for automatic screen swapping
;	when running either QC or CV.
;

CrtDefSegs <dbdata>
sBegin	dbData
	assumes	DS,data
externW	__aDBswpflg
externW __aDBswpchk
sEnd	dbData
extrn	__aDBdoswp:ABS
endif	; _DEBUGSCREEN


externP _chkstk 		; give stack overflow error and die
externP _stackavail		; return available stack space

extrn	__dosretax:near

ifdef  _QWIN
externNP   _wwrite		; Write to QWIN window handle
endif

sBegin	code

	assumes cs,code
	assumes ds,data

page
;***
;int _write(fh, buf, cnt) - write bytes to a file handle
;
;Purpose:
;	Writes count bytes from the buffer to the handle specified.
;	If the file was opened in text mode, each LF is translated to
;	CR-LF.	This does not affect the return value.	In text
;	mode ^Z indicates end of file.
;
;	Multi-thread notes:
;	(1) write() - Locks/unlocks file handle
;	    _write_lk() - Does NOT lock/unlock file handle
;	(2) It is assumed in this source that MTHREAD can only be
;	true under OS/2.  Thus, conditional code is contained within
;	MTHREAD conditionals without additional OS2 conditionals.
;
;Entry:
;	int fh - file handle to write to
;	char *buf - buffer to write from
;	unsigned int cnt - number of bytes to write
;
;Exit:
;	returns number of bytes actually written.
;	This may be less than cnt, for example, if out of disk space.
;	returns -1 (and set errno) if fails.
;
;Uses:
;
;Exceptions:
;
;*******************************************************************************

 ;--- Non-multithread version of write
cProc	_write,<PUBLIC>,<>

	parmW	fh
	parmDP	buf
	parmW	cnt
	localW	outcnt		;# of chars written
	localW	lfcnt		;# of LFs translated
	localW	oldds		;DS save area
	localW	oldsp		;SP save area
Ifdef _QWIN
	localW	__nfile_	; SS relative __nfile value
endif

cBegin
	;fall thru


write1:
	; make sure handle is in range

	mov	bx,fh		; get file handle

ifdef _QWIN
	mov	ax,[__nfile]	; ax = max OS file handle
	mov	[__nfile_],ax	; save on stack for later
	cmp	[__qwinused],0	; QWIN system enabled ?
	je	test_fh 	; no, jump down
	mov	ax,[__wnfile]	; yes, use QWIN max file handle
	cmp	bx,_MAX_STDFH	; adjust stdin/out/err as necessary
	ja	test_fh
	mov	bx,[__nfile]	; yes, use QWIN std file
	mov	[fh],bx 	; update input handle with new value
test_fh:
	cmp	bx,ax		; handle in range ?
	jb	handle_okay	; yes, continue
	;fall thru		; no, error
else	;!_QWIN
	cmp	bx,[__nfile]	; handle in range ?
	jb	handle_okay	; yes, continue
endif	;_QWIN

	mov	ax,EBADF shl 8 + 0 ; file handle is out of range
	stc
to_dosretax:
	jmp	__dosretax	; error on lseek (invalid file handle)


handle_okay:


ifdef _DEBUGSCREEN
	cmp	__aDBswpflg,__aDBdoswp	; See if we should screen swap
	jne	@F			; No -- skip over call
	cCall	__aDBswpchk		; Yes -- try to do the check
@@:
endif	; _DEBUGSCREEN


	test	__osfile[bx],FAPPEND ; check for append
	jz	noseek1 	; not appending, continue

;Append mode - seek to end of file

ifdef _QWIN
; QWIN files are never in append mode so this code won't be reached.
endif

	mov	ax,DOS_lseek shl 8 + 2 ; appending, lseek to end
	xor	cx,cx
	mov	dx,cx		; 0L
	callos
	jc	to_dosretax	; if no error, continue

noseek1:
	test	__osfile[bx],FTEXT ; check for text (DOS finds err)
	jz	writebin0	; do it without translation
	;fall thru		; do the cr/lf translation

; --- Translate LF => CR/LF ---
; We get here if we have to translate LF's to CR/LF's on output

translate:

;put input buffer address in es:si

if	sizeD
	mov	[oldds],ds	; save ds
	mov	es,word ptr (buf)+2 ; es = ds
	lds	dx,buf		; get buffer address
else
	mov	dx,buf		; get buffer address
	push	ds
	pop	es		; es = ds
endif
	xor	ax,ax
	mov	[outcnt],ax	;zero out char counter
	mov	[lfcnt],ax	;zero out lf counter, too

	cld
	push	di		; save di
	push	si		; save si
	mov	di,dx		; es:di = start of search
	mov	si,dx		; ds:si = start of search, too

;Scan for LFs in the user's buffer.
;(1) If none, write the buffer out in one shot.
;(2) If there is an LF, buffer the output doing translation.

lfscan:
	mov	[oldsp],sp	;save sp
	mov	cx,[cnt]	;get char move count
	jcxz	j_writedone	;done if count = 0

	mov	al,C_LF		;set up for scan
	repnz	scasb		;scan for LF
	jnz	writebin1	;no LFs - write out in binary mode
	;fall thru		;LFs - use the internal buffer

;Move chars from input buffer to LF buffer doing translation as needed.
;ds:si = start of input buffer

if	sizeD
	push	ds		;save input buffer ds
	mov	ds,[oldds]	;get original ds
endif
	cCall	_stackavail	;ax = # bytes on stack
	cmp	ax,LFBUFFMIN+STACKSAVE ;is there enough room on stack?
	jbe	stackerr	;nope - return an error
if	sizeD
	pop	ds		;get input buffer ds back
endif
	sub	sp,2		;move sp to first free word
	mov	bx,sp		;bx = end of LF buffer
	mov	dx,LFBUFFMAX	;assume max LF buff size
	cmp	ax,LFBUFFMAX+STACKSAVE ;stack space > max LF buff size ??
	jae	lfbuff		;yes, use the max LF buff size
	mov	dx,LFBUFFMIN	;no, use the min LF buff size
lfbuff:
	sub	sp,dx		;move sp past LF buffer
	mov	dx,sp		;dx = start of LF buffer
	mov	di,dx		;di = start of LF buffer also

	push	ss		;es gets LF buffer segment
	pop	es

	mov	cx,[cnt]	;cx = # of chars to move

;Main body of loop
;	al = reserved for current character
;	bx = end of LF buffer
;	cx = count of chars left to write
;	dx = beginning of LF buffer
;	ds:si = curr position in input buffer
;	es:di = curr position in LFBUFF

lfloop:
	lodsb			;al = next byte from input
	cmp	al,C_LF		;curr char == LF ?
	je	foundlf 	;yes - do the translation
lfloop1:
	cmp	di,bx		;is LF buffer full ?
	je	wrlfbuff1	;if so, write it out
storechr:
	stosb			;al ->	LFBUFF and bump di
	loop	lfloop		;do next char
	;fall thru		;no more input (cx = 0)

;No more input - write out anything that's in the LF buffer

	call	wrlfbuff	;write out the buffer
IFDEF _WINDOWS
j_writedone:
	jmp	writedone	;all done!
ELSE
j_writedone:
	jmp	short writedone ;all done!
ENDIF

;Found an LF - do the translation

foundlf:
	mov	al,C_CR		;put a CR in the buffer
	cmp	di,bx		;LF buffer full ?
	jne	foundlf1	;nope - store the CR
	call	wrlfbuff	;write out the LF buffer
foundlf1:
	stosb			;CR -> LFBUFF and bump di
	mov	al,C_LF		;get LF back
	inc	[lfcnt] 	;bump LF count
	jmp	short lfloop1	;store the LF

;Call to wrlfbuff used by the lfloop

wrlfbuff1:
	call	wrlfbuff	;write out the buffer
	jmp	short storechr	;back into loop

;Bridges

writebin1:
	pop	si		;restore si/di
	pop	di
if	sizeD
	mov	ds,[oldds]	;restore original ds
endif

writebin0:
ifdef _QWIN
	jmp	writebin	;binary write code
else
	jmp	short writebin	;binary write code
endif


;Error - could not get enough stack space

stackerr:


	; call _chkstk with a value guaranteed to give an error

	mov	ax, -4
	callcrt _chkstk 	;give stack overflow and die
	;never returns

page
;***
;wrlfbuff - Write out the lfbuffer
;
;Purpose:
;	This routine writes out the lf buffer and resets appropriate
;	registers.
;Entry:
;	Registers still setup from LF/CR translation loop.
;	Pertinent values for wrlfbuff() are:
;		dx = beginning of LF buffer
;		di = current position in LF buffer
;Exit:
;	Resets di to the beginning of the LF buffer.
;
;Uses:
;
;Exceptions:
;
;*******************************************************************************

wrlfbuff proc	near

	push	ax		;save current char
	push	bx		;save end of buffer pointer
	push	cx		;save cx
if	sizeD
	push	ds		;save ds
	push	es		;set ds == es
	pop	ds
else
ifdef	_WINDLL
	push	ds		;save ds
	push	es		;set ds == es
	pop	ds
endif
endif

;calculate the # of chars to write out

	mov	cx,di		;cx = calc # of bytes to write
	sub	cx,dx
	jcxz	wrlfdone	;if cx == 0, we're done

	push	cx		;save char count

;do the write


ifdef _QWIN
	mov	bx,[fh] 	; bx = adjusted handle
	cmp	bx,[__nfile_]	; is this a QWIN or OS file handle ?
	jb	oscall1
	call	_wwrite 	; call QWIN
	jmp	short after1
oscall1:			; call OS
	callos	write
after1:
else	;!_QWIN
	mov	bx,fh		;bx = file handle
	mov	ah,DOS_write	;write call
	callos			;do the write
endif	;_QWIN

	pop	cx		;restore chars written
	jc	wrlferror	;error

	add	[outcnt],ax	;add chars written to total
	cmp	cx,ax		;did we write less than we wanted
	ja	wrlferror	;yes - return error, if we jump, CF=0

;--- no error on the write ---
;Restore/re-initialize registers and return.

wrlfdone:

if	sizeD
	pop	ds		;restore ds
else
ifdef	_WINDLL
	pop	ds		;restore ds
endif
endif
	pop	cx		;restore register
	pop	bx
	pop	ax
	mov	di,dx		;make di = beginning of LF buffer
	ret			;return to caller

;--- error on the write ---
;Either the write returned an explicit error or we wrote less than requested.
;Either way, we are not returning to the caller.

wrlferror:

	lahf			;save carry for a sec...

if	sizeD
	pop	ds		;restore ds
else
ifdef	_WINDLL
	pop	ds		;restore ds
endif
endif
	add	sp,8		;clean off stack (don't change ax)
				;cleans off return address, too
	cmp	[outcnt],0	;have we written something?
	jne	writedone	;yes, return how much

	sahf			;restore carry

	jnc	wrote0		;carry set ?
	mov	ah,EBADF	;yes - error on write
	jmp	short writeerror ;error return

; The write did not return an error but we didn't write anything.
; if dev and first byte ^z, just return 0. else return end of media error.
; (AX=0)

wrote0:

if	sizeD
	mov	ds,[oldds]	; restore original ds
endif
	test	__osfile[bx],FDEV ; device ?
	jz	wrlferr1	; no, error
if	sizeD
	mov	ds,word ptr (buf)+2 ; restore buffer ds
endif
	mov	bx,word ptr (buf)
	cmp	byte ptr [bx],C_SUB ; ^z ?
	jne	wrlferr1	; no

	clc			; no error
	jmp	short writeerror ; don't overwrite ax (ax=0)

wrlferr1:			; return an error
	stc			; carry set for error
	mov	ax,ENOSPC shl 8 + 0 ; return no more disk space error
	jmp	short writeerror ; return the error

writedone:			; good return
	mov	ax,[outcnt]	; total # chars written
	sub	ax,[lfcnt]	; subtract the # of LFs translated
				; clears carry, too

writeerror:			; error return
	mov	sp,[oldsp]	; restore sp
	pop	si		; restore si
	pop	di		; restore di
if	sizeD
	mov	ds,[oldds]	; restore original DS
endif

justret:
	jmp	__dosretax	; return AX if successful

wrlfbuff endp			;end of wrlfbuff routine

;--- Untranslated Writes ---
; Just shove the entire buffer out there as fast as possible
; ds = dgroup

writebin:
	mov	cx,cnt		; number of bytes to write
	or	cx,cx		; are we supposed to write 0 bytes?
	jnz	writegoon	; nope, continue
	mov	ax,cx		; yes, ax = byte count = 0
	jmp	__dosretax	; good return

writegoon:

if	sizeD
	push	ds
	lds	dx,buf		; buffer address
else
	mov	dx,buf		; buffer address
endif


ifdef _QWIN
	cmp	bx,[__nfile_]	; is this a QWIN or OS file handle ?
	jb	oscall2
	call	_wwrite 	; call QWIN
	jmp	short after2
oscall2:			; call OS
	callos	write
after2:
else	;!_QWIN
	callos	write
endif	;_QWIN


if	sizeD
	push	ds
	pop	es
	pop	ds
endif

	jnc	writeok4

	mov	ah,EBADF
	jmp	short justret
writeok4:			;no write error  (ax = # bytes written)
	or	ax,ax		;did we write 0 bytes ?
	jnz	justret 	;no, just return

; Requested non-zero number of bytes to be written and 0 were written.
; If device and 1st byte was ^z, just return 0. else end of media

	test	__osfile[bx],FDEV ; device?
	jz	notdev		;   no

	mov	bx,dx

if	sizeD
	cmp	byte ptr es:[bx],C_SUB ; ^z ?
else
	cmp	byte ptr [bx],C_SUB ; ^z ?
endif

	jne	notdev

	clc
	jmp	short justret	; good return
notdev:
	stc			; set carry flag to mark error
	mov	ax,ENOSPC shl 8 + 0 ; return no more disk space error
	jmp	short justret	; return AX
cEnd	nogen


sEnd
	end
