/***
*clearerr.c - clear error and eof flags
*
*   Copyright (c) 1985-1992, Microsoft Corporation.  All rights reserved.
*
*Purpose:
*   defines clearerr() - clear error and eof flags from a stream
*
*******************************************************************************/

#include <stdio.h>
#include <assert.h>
#include <file2.h>
#include <internal.h>
#include <msdos.h>


/***
*void clearerr(stream) - clear error and eof flags on a stream
*
*Purpose:
*   Resets the error and eof indicators for a stream to 0
*
*Entry:
*   FILE *stream - stream to set indicators on
*
*Exit:
*   No return value.
*   changes the _flag field of the FILE struct.
*
*Exceptions:
*
*******************************************************************************/

void 
clearerr (stream)
FILE *stream;
{

    assert(stream != NULL);



    /* Clear stdio level flags */
    stream->_flag &= ~(_IOERR|_IOEOF);

    /* Clear lowio level flags */
    _osfile[_fileno(stream)] &= ~(FEOFLAG);

}
