/***
*closeall.c - close all open files
*
*   Copyright (c) 1985-1992, Microsoft Corporation.  All rights reserved.
*
*Purpose:
*   defines fcloseall() - closes all open files except stdin, stdout
*   stdprn, stderr, and stdaux.
*
*******************************************************************************/

#include <stdio.h>
#include <file2.h>
#include <register.h>
#include <internal.h>


/***
*int _fcloseall() - close all open streams
*
*Purpose:
*   Closes all streams currently open except for stdin/out/err/aux/prn.
*   tmpfile() files are among those closed.
*
*   No std files in windows, so close ALL files.
*
*Entry:
*   None.
*
*Exit:
*   returns number of streams closed if OK
*   returns EOF if fails.
*
*Exceptions:
*
*******************************************************************************/

int 
_fcloseall ()
{

#ifdef _WINDOWS
#ifdef _QWIN
    REG1 FILE _NEAR_ *stream;
#else
    REG1 FILE _NEAR_ *stream = &_iob[0];
#endif
#else
    REG1 FILE _NEAR_ *stream = &_iob[5];
#endif
    REG2 int count = 0;


#ifdef _QWIN
    if (_qwinused)
        stream = &_iob[3];
    else
#ifdef _BAT16
        stream = &_iob[3];
#else
        stream = &_iob[0];
#endif //_BAT16
#endif

    for (; stream <= _lastiob; stream++)
        if (fclose(stream) != EOF)
            count++;


    return(count);
}
