/***
*fclose.c - close a file
*
*   Copyright (c) 1985-1992, Microsoft Corporation.  All rights reserved.
*
*Purpose:
*   defines fclose() - close an open file
*
*******************************************************************************/

#include <stdio.h>
#include <file2.h>
#include <register.h>
#include <assert.h>
#include <string.h>
#include <io.h>
#include <stdlib.h>
#include <internal.h>
#include <dos.h>


/***
*int fclose(stream) - close a stream
*
*Purpose:
*   Flushes and closes a stream and frees any buffer associated
*   with that stream, unless it was set with setbuf.
*
*Entry:
*   FILE *stream - stream to close
*
*Exit:
*   returns 0 if OK, EOF if fails (cant _flush, not a FILE, not open, etc.)
*   closes the file -- affecting FILE structure
*
*Exceptions:
*
*******************************************************************************/


int  fclose(str)
FILE *str;
{
    REG1 FILE _NEAR_ *stream;
    REG2 int result = EOF;
    int tmp;
    _WINSTATIC char tmpname[L_tmpnam];
    char *ptmp;

    /* Init near stream pointer */
    stream = (FILE _NEAR_ *) FP_OFF(str);

    if (stream->_flag & _IOSTRG) {
        stream->_flag = 0;
        return(EOF);
    }


    assert(str != NULL);

    if (inuse(stream)) {

        /* Stream is in use:
           (1) flush stream
           (2) free the buffer
           (3) close the file
           (4) delete the file if temporary
        */

        result = _flush(stream);
        tmp = _tmpnum(stream);
        _freebuf(stream);

#ifdef _QWIN
        /* issue OS or QWIN close appropriately */

        if (
             (_fileno(stream) > _nfile) ?
             (_wclose(_fileno(stream),0) < 0) :
             (_close(_fileno(stream)) < 0)
           )
            result = EOF;
#else
        if (_close(_fileno(stream)) < 0)
            result = EOF;
#endif

        else if ( tmp ) {
            /* File is temporary; build pathname and delete file */

            strcpy( tmpname, P_tmpdir );
            ptmp = tmpname + sizeof(P_tmpdir);

            if (*(ptmp-2) != '\\')
                strcat(tmpname,"\\");
            else
                ptmp--;

            _itoa (tmp, ptmp, 10);

            if ( _unlink( tmpname ) )
                result = EOF ;
        }
    }

    stream->_flag = 0;
    return(result);
}
