/***
*fgetpos.c - Contains the fgetpos runtime
*
*   Copyright (c) 1987-1992, Microsoft Corporation. All Rights Reserved.
*
*Purpose:
*   Get file position (in an internal format).
*
*******************************************************************************/

#include <stdio.h>


/***
*int fgetpos(stream,pos) - Get file position (internal format)
*
*Purpose:
*   Fgetpos gets the current file position for the file identified by
*   [stream].  The file position is returned in the object pointed to
*   by [pos] and is in internal format; that is, the user is not supposed
*   to interpret the value but simply use it in the fsetpos call.  Our
*   implementation simply uses fseek/ftell.
*
*Entry:
*   FILE *stream = pointer to a file stream value
*   fpos_t *pos = pointer to a file position value
*
*Exit:
*   Successful fgetpos call returns 0.
*   Unsuccessful fgetpos call returns non-zero (!0) value and sets
*   ERRNO (this is done by ftell and passed back by fgetpos).
*
*Exceptions:
*   None.
*******************************************************************************/


int  fgetpos(stream,pos)

FILE *stream;
fpos_t *pos;

{
    if ((*pos=ftell(stream)) != -1)
        return(0);
    else
        return(-1);
}
