/***
*fopen.c - open a file
*
*   Copyright (c) 1985-1992, Microsoft Corporation.  All rights reserved.
*
*Purpose:
*   defines fopen() and _fsopen() - open a file as a stream and open a file
*   with a specified sharing mode as a stream
*
*******************************************************************************/

#include <stdio.h>
#include <share.h>
#include <register.h>
#include <assert.h>
#include <internal.h>
#include <file2.h>


/***
*FILE *_fsopen(file, mode, shflag) - open a file
*
*Purpose:
*   Opens the file specified as a stream.  mode determines file mode:
*   "r": read   "w": write  "a": append
*   "r+": read/write        "w+": open empty for read/write
*   "a+": read/append
*   Append "t" or "b" for text and binary mode. shflag determines the
*   sharing mode. Values are the same as for sopen().
*
*Entry:
*   char *file - file name to open
*   char *mode - mode of file access
*
*Exit:
*   returns pointer to stream
*   returns NULL if fails
*
*Exceptions:
*
*******************************************************************************/

FILE * 
_fsopen (file, mode, shflag)
const char *file;
const char *mode;
int shflag;
{
    REG1 FILE *stream;
    REG2 FILE *retval;

    assert(file != NULL);
    assert(*file != '\0');
    assert(mode != NULL);
    assert(*mode != '\0');

    /* Get a free stream */
    /* [NOTE: _getstream() returns a locked stream.] */

    if ((stream = _getstream()) == NULL)
        return(NULL);

    /* open the stream */
    retval = _openfile(file,mode,shflag,stream);

    /* unlock stream and return. */
    return(retval);
}


/***
*FILE *fopen(file, mode) - open a file
*
*Purpose:
*   Opens the file specified as a stream.  mode determines file mode:
*   "r": read   "w": write  "a": append
*   "r+": read/write        "w+": open empty for read/write
*   "a+": read/append
*   Append "t" or "b" for text and binary mode
*
*Entry:
*   char *file - file name to open
*   char *mode - mode of file access
*
*Exit:
*   returns pointer to stream
*   returns NULL if fails
*
*Exceptions:
*
*******************************************************************************/

FILE * 
fopen (file, mode)
const char *file;
const char *mode;
{
    return( _fsopen(file, mode, _SH_COMPAT) );
}
