/***
*fprintf.c - print formatted data to stream
*
*   Copyright (c) 1985-1992, Microsoft Corporation.  All rights reserved.
*
*Purpose:
*   defines fprintf() - print formatted data to stream
*
*******************************************************************************/

#include <stdio.h>
#include <register.h>
#include <assert.h>
#include <stdarg.h>
#include <file2.h>
#include <internal.h>
#include <dos.h>


/***
*int fprintf(stream, format, ...) - print formatted data
*
*Purpose:
*   Prints formatted data on the given using the format string to
*   format data and getting as many arguments as called for
*   _output does the real work here
*
*Entry:
*   FILE *stream - stream to print on
*   char *format - format string to control data format/number of arguments
*   followed by arguments to print, number and type controlled by
*   format string
*
*Exit:
*   returns number of characters printed
*
*Exceptions:
*
*******************************************************************************/

int 
fprintf (FILE *str, const char *format, ...)

/*
 * 'F'ile (stream) 'PRINT', 'F'ormatted
 */
{
    va_list(arglist);
    REG1 FILE _NEAR_ *stream;
    REG2 int buffing;
    int retval;

    va_start(arglist, format);

    assert(str != NULL);
    assert(format != NULL);

    /* Init stream pointer */
    stream = (FILE _NEAR_ *) FP_OFF(str);

    buffing = _stbuf(stream);
    retval = _output(stream,format,arglist);
    _ftbuf(buffing, stream);

    return(retval);
}
