/***
*freopen.c - close a stream and assign it to a new file
*
*   Copyright (c) 1985-1992, Microsoft Corporation.  All rights reserved.
*
*Purpose:
*   defines freopen() - close and reopen file, typically used to redirect
*   stdin/out/err/prn/aux.
*
*******************************************************************************/

#include <stdio.h>
#include <file2.h>
#include <share.h>
#include <register.h>
#include <assert.h>
#include <internal.h>
#include <dos.h>


/***
*FILE *freopen(filename, mode, stream) - reopen stream as new file
*
*Purpose:
*   Closes the file associated with stream and assigns stream to a new
*   file with current mode.  Usually used to redirect a standard file
*   handle.
*
*Entry:
*   char *filename - new file to open
*   char *mode - new file mode, as in fopen()
*   FILE *stream - stream to close and reassign
*
*Exit:
*   returns stream if successful
*   return NULL if fails
*
*Exceptions:
*
*******************************************************************************/

FILE * 
freopen (filename, mode, str)
const char *filename;
const char *mode;
FILE *str;
{
    REG1 FILE _NEAR_ *stream;
    FILE *retval;

    assert(filename != NULL);
    assert(*filename != '\0');
    assert(mode != NULL);
    assert(str != NULL);

    /* Init stream pointer */
    stream = (FILE _NEAR_ *) FP_OFF(str);



    if (inuse(stream) && fclose(stream) == EOF) {
        retval = NULL;
        goto done;
    }

    stream->_ptr = stream->_base = NULL;
    stream->_cnt = stream->_flag = 0;
    retval = _openfile(filename,mode,_SH_COMPAT,stream);

/* Common return code */

done:
    return(retval);
}
