/***
*fscanf.c - read formatted data from stream
*
*   Copyright (c) 1985-1992, Microsoft Corporation.  All rights reserved.
*
*Purpose:
*   defines fscanf() - reads formatted data from stream
*
*******************************************************************************/

#include <stdio.h>
#include <assert.h>
#include <stdarg.h>
#include <internal.h>
#include <file2.h>


/***
*int fscanf(stream, format, ...) - read formatted data from stream
*
*Purpose:
*   Reads formatted data from stream into arguments.  _input does the real
*   work here.
*
*Entry:
*   FILE *stream - stream to read data from
*   char *format - format string
*   followed by list of pointers to storage for the data read.  The number
*   and type are controlled by the format string.
*
*Exit:
*   returns number of fields read and assigned
*
*Exceptions:
*
*******************************************************************************/

int 
fscanf (FILE *stream, const char *format, ...)

/*
 * 'F'ile (stream) 'SCAN', 'F'ormatted
 */
{
    int retval;

    va_list arglist;

    va_start(arglist, format);

    assert(stream != NULL);
    assert(format != NULL);

    retval = (_input(stream,(const unsigned char *)format,arglist));

    return(retval);
}
