/***
*fsetpos.c - Contains fsetpos runtime
*
*   Copyright (c) 1987-1992, Microsoft Corporation. All Rights Reserved.
*
*Purpose:
*   Fsetpos sets the file position using an internal value
*   returned by an earlier fgetpos call.
*
*******************************************************************************/

#include <stdio.h>


/***
*int fsetpos(stream,pos) - Set file positioning
*
*Purpose:
*   Fsetpos sets the file position for the file indicated by [stream] to
*   the position indicated by [pos].  The [pos] value is defined to be in
*   an internal format (not to be interpreted by the user) and has been
*   generated by an earlier fgetpos call.
*
*Entry:
*   FILE *stream = pointer to a file stream value
*   fpos_t *pos = pointer to a file positioning value
*
*Exit:
*   Successful call returns 0.
*   Unsuccessful call returns non-zero (!0).
*
*Exceptions:
*   None.
*******************************************************************************/

int  fsetpos(stream,pos)

FILE *stream;
const fpos_t *pos;

{
    return(fseek(stream,*pos,SEEK_SET));
}
