/***
*ftell.c - get current file position
*
*   Copyright (c) 1985-1992, Microsoft Corporation.  All rights reserved.
*
*Purpose:
*   defines ftell() - find current current position of file pointer
*
*******************************************************************************/

#include <stdio.h>
#include <register.h>
#include <file2.h>
#include <assert.h>
#include <errno.h>
#include <msdos.h>
#include <stddef.h>
#include <io.h>
#include <internal.h>
#include <dos.h>


/***
*long ftell(stream) - query stream file pointer
*
*Purpose:
*   Find out what stream's position is. coordinate with buffering; adjust
*   backward for read-ahead and forward for write-behind. This is NOT
*   equivalent to fseek(stream,0L,1), because fseek will remove an ungetc,
*   may flush buffers, etc.
*
*Entry:
*   FILE *stream - stream to query for position
*
*Exit:
*   return present file position if succeeds
*   returns -1L and sets errno if fails
*
*Exceptions:
*
*******************************************************************************/


long 
ftell (str)
FILE *str;
{



    REG1 FILE _NEAR_ *stream;
    FILE2 _NEAR_ *stream2;
    unsigned int offset;
    long filepos;
    REG2 char *p;
    char *max;
    int fd;
    unsigned int rdcnt;

    assert(str != NULL);

    /* Init stream pointer and file descriptor */
    stream = (FILE _NEAR_ *) FP_OFF(str);
    stream2 = &(_iob2_(stream));
    fd = _fileno(stream);

    if (stream->_cnt < 0)
    stream->_cnt = 0;
    if ((filepos = _lseek(fd, 0L, SEEK_CUR)) < 0L)
    return(-1L);

    if (!bigbuf2(stream,stream2))  /* _IONBF or no buffering designated */
    return(filepos - stream->_cnt);

    offset = stream->_ptr - stream->_base;

    if (stream->_flag & (_IOWRT|_IOREAD)) {
    if (_osfile[fd] & FTEXT)
        for (p = stream->_base; p < stream->_ptr; p++)
        if (*p == '\n')  /* adjust for '\r' */
            offset++;
    }
    else if (!(stream->_flag & _IORW)) {
    errno=EINVAL;
    return(-1L);
    }

    if (filepos == 0L)
    return((long)offset);

    if (stream->_flag & _IOREAD)    /* go to preceding sector */

    if (stream->_cnt == 0)      /* filepos holds correct location */
        offset = 0;

    else {

        /* Subtract out the number of unread bytes left in the
           buffer.  [We can't simply use _iob2[]._bufsiz because
           the last read may have hit EOF and, thus, the buffer
           was not completely filled.] */

        rdcnt = stream->_cnt + (stream->_ptr - stream->_base);

        /* If text mode, adjust for the cr/lf substitution. If binary
           mode, we're outta here. */

        if (_osfile[fd] & FTEXT) {

        /* (1) If we're not at eof, simply copy _bufsiz onto rdcnt
           to get the # of untranslated chars read. (2) If we're at
           eof, we must look through the buffer expanding the '\n'
           chars one at a time. */

        /* [NOTE: Performance issue -- it is faster to do the two
           lseek() calls than to blindly go through and expand the
           '\n' chars regardless of whether we're at eof or not.] */

        if (_lseek(fd, 0L, 2) == filepos) {

            max = stream->_base + rdcnt;
            for (p = stream->_base; p < max; p++)
            if (*p == '\n')  /* adjust for '\r' */
                rdcnt++;

            /* If last byte was ^Z, the lowio read didn't tell us
               about it.  Check flag and bump count, if necessary. */

            if (stream2->_flag2 & _IOCTRLZ)
            ++rdcnt;
            }

        else {

            _lseek(fd, filepos, 0);
            rdcnt = stream2->_bufsiz;

            /* If first byte in untranslated buffer was a '\n',
               assume it was preceeded by a '\r' which was discarded
               by the previous read operation and count the '\n'. */

            if  (_osfile[fd] & FCRLF)
            ++rdcnt;

            }

        } /* end if FTEXT */

        filepos -= (long)rdcnt;
        }

    return(filepos + (long)offset);
}
