	page	,132
	title	fgetc - read a character from a stream
;***
;fgetc.asm - read a character from a stream
;
;	Copyright (c) 1985-1992, Microsoft Corporation. All rights reserved.
;
;Purpose:
;	Defines fgetc() and getc() (read a character from a stream), and
;	fgetchar() and getchar() (read a character from stdin).
;
;*******************************************************************************
;
; --- C VERSION OF ROUTINES
;
; #include <stdio.h>
;
; int _LOAD_DS
; _fgetchar ()
; {
;     return(getc(stdin));
; }
;
;
; #include <stdio.h>
; #include <register.h>
; #include <assertm.h>
; #include <file2.h>
; #include <os2dll.h>
;
; int _LOAD_DS
; fgetc (stream)
; REG1 FILE *stream;
; {
;     int retval;
; #ifdef MTHREAD
;     int index;
; #endif
;
;     assert(stream,"stream==NULL");
;
; #ifdef MTHREAD
;     index = _iob_index(stream);
; #endif
;     _lock_str(index);
;     retval = _getc_lk(stream);
;     _unlock_str(index);
;
;     return(retval);
; }
;
; --- END OF C VERSION
;

.xlist
include version.inc
include cmacros.inc
include stdio.inc
include os2dll.inc
.list

externP _filbuf 			; fill stream buffer



sBegin	data
	assumes ds,data

externW _iob

ifdef _QWIN
externW _qwinused			; QWIN in use flag
endif

sEnd	data


sBegin code
	assumes cs,code
	assumes ds,data


;***
;int _fgetchar(), getchar() - read a character from stdin
;
;Purpose:
;	Read a character from stdin. getchar() is normally a macro, but must
;	also be available as a function for ANSI. fgetchar() and the function
;	version of getchar() are identical.
;
;Entry:
;	None.
;
;Exit:
;	Returns character read or EOF if at end-of-file or an error occured,
;	in which case the appropriate flag is set in the FILE structure.
;
;Exceptions:
;
;*******************************************************************************

ifndef _WINDLL

cProc	getchar,<PUBLIC>,<>

cBegin	<nogen>
cEnd	<nogen>

cProc	_fgetchar,<PUBLIC>,<>

cBegin
ifdef	_QWIN
	cmp	[_qwinused],0		; QWIN in use?
	jne	@F			; yes, stdin is legal
	mov	ax,EOF			; nope, return an error
	jmp	short return
@@:
endif
	mov	bx,stdin		; bx = stream (stdin)
	jmp	short havestr		; jump to common code
cEnd	<nogen>

endif  ;!_WINDLL

;***
;int fgetc(stream), getc(stream) - read a character from a stream
;
;Purpose:
;	Reads a character from the given stream. getc() is normally a macro,
;	but must also be available as a function for ANSI. As a function,
;	getc() is identical to fgetc().
;
;Entry:
;	FILE *stream - stream to read character from
;
;Exit:
;	returns the character read
;	returns EOF if at end of file or error occurred
;
;Exceptions:
;
;*******************************************************************************


	EVEN				; force word alignment

cProc	getc,<PUBLIC>,<>

cBegin	<nogen>
cEnd	<nogen>

cProc	fgetc,<PUBLIC>,<>

	parmDP	stream

cBegin

; The following instruction is only place where the argument stream is
; referenced!

	mov	bx,word ptr [stream]	; bx = stream

; fgetchar() and getchar() enter here. The remainder of the code is common
; to all four of the get-a-character functions.

havestr::

ifdef	_LOAD_DGROUP
	push	ds
	mov	ax,DGROUP
	mov	ds,ax
endif	;_LOAD_DGROUP


	dec	[bx]._cnt
	js	dofilbuf		; go call _filbuf if _cnt < 0
	inc	word ptr [bx]._ptr

if	sizeD
	les	bx,[bx]._ptr
	mov	al,byte ptr es:[bx-1]	; al = char fetched from stream buffer
else	;not sizeD
	mov	bx,[bx]._ptr
	mov	al,byte ptr [bx-1]	; al = char fetched from stream buffer
endif	;sizeD

	xor	ah,ah			; zero out ah
	jmp	short done

dofilbuf:
if	sizeD
	push	ds
endif
	push	bx			; push stream pointer

	callcrt _filbuf

	pop	bx			; clean off stack
if	sizeD
	pop	bx
endif

done:

ifdef	_LOAD_DGROUP
	pop	ds
endif	;_LOAD_DGROUP

return:

cEnd	<nolocals>

sEnd	code
	end
