	page	,132
	title	gets - read a line from stdin
;***
;gets.asm - read a line from stdin
;
;	Copyright (c) 1988-1992, Microsoft Corporation. All rights reserved.
;
;Purpose:
;	Defines gets() - read a line from stdin into buffer
;
;*******************************************************************************


.xlist
include version.inc
include cmacros.inc
include stdio.inc
include os2dll.inc
.list

sBegin	data
	assumes ds,data

externW _iob				; stream array

ifdef _QWIN
externW _qwinused			; QWIN in use flag
endif

sEnd	data

_STDIN	equ	0			; index of stdin is 0

externP _filbuf 			; fill stream buffer


sBegin code
	assumes cs,code
	assumes ds,data

;***
;char *gets( char *string ) - read a line from stdin
;
;Purpose:
;	Read characters from stdin into the buffer (string) until a '\n'
;	or EOF is encountered. Then, append a null character onto the end.
;	Note that the '\n', if read, is NOT copied into the buffer. Also
;	note that is simply ASSUMED that there is enough room in the buffer
;	to hold the read string.
;
;Entry:
;	string	- pointer to buffer to hold the read string
;
;Exit:
;	returns string if successful
;	returns NULL if EOF is encountered immediately
;		in this case, the contents of string are not altered
;	returns NULL if an error occurs
;		in this case, the contents of string are indeterminate
;
;*******************************************************************************

cProc	gets,<PUBLIC>,<si,di>

	parmDP	string

cBegin

ifdef	_LOAD_DGROUP
	push	ds
	mov	ax,DGROUP
	mov	ds,ax
endif	;_LOAD_DGROUP


ifdef	_QWIN
	cmp	[_qwinused],0		; QWIN in use?
	je	retnull 		; nope, can't use stdin
endif


;**
; Set:
;	ds:bx = stdin
;	es:di = string

	mov	bx,stdin		; ds:bx = stream pointer

if sizeD
	les	di,[string]		; es:di = caller's buffer
else
	push	ds
	pop	es
	mov	di,[string]		; es:di = caller's buffer
endif

loopbegin:

;**
; Check to see if the stream buffer is empty. If not, process the characters
; in the buffer.

	mov	cx,[bx]._cnt
	jcxz	dofilbuf

if sizeD
	push	ds			; save DGROUP
	lds	si,[bx]._ptr		; ds:si = pointer to stream buffer
	assumes ds,nothing
else
	mov	si,[bx]._ptr		; ds:si = pointer to stream buffer
endif

	mov	ah,0Ah			; ah = linefeed character
	push	cx			; save number of chars

even

nextchar:
	lodsb				; get a byte
	stosb				; place in user's buffer
	cmp	al,ah			; was it a linefeed?
	loopne	nextchar
	pop	ax			; ax = loop entry value of cx

if sizeD
	pop	ds			; restore DGROUP
	assumes ds,data
endif

	mov	word ptr [bx]._ptr,si	; update stream pointer
	je	foundlf

	sub	[bx]._cnt,ax		; update stream count
	jmp	short loopbegin

; The stream buffer is empty so call _filbuf to fill it up and process the
; single character returned by _filbuf. Note that in the case of single
; character buffering (aka no input buffering at all), the stream buffer
; will be empty again after the call to _filbuf so that the we end up doing
; character-at-a-time processing (as we should).

dofilbuf:
	push	es			; save registers
	push	bx

if sizeD
	push	ds			; push arg
	push	bx
else
	push	bx			; push arg
endif

	callcrt _filbuf 		; _filbuf(stream)

if sizeD
	add	sp,4			; clean off arg
else
	pop	dx			; clean off arg
endif

	pop	bx
	pop	es

	cmp	al,0Ah			; was it a linefeed (aka newline)
	je	appendnull		;   yes
	cmp	ax,EOF			; are we at end-of-file?
	je	ateof			;   yes
	stosb				; put the char in the user's buffer
	jmp	short loopbegin

ateof:
	cmp	di,word ptr [string]	; have we read in anything yet?
	je	retnull 		;   no, go return a NULL
	test	[bx]._flag,_IOERR	; did an error occur?
	jz	appendnull		;   no, do a normal return
	; fall thru

retnull:
	xor	ax,ax
if sizeD
	cwd
endif
	jmp	short done

foundlf:
	sub	ax,cx			; number of characters copied over
	sub	[bx]._cnt,ax		; update stream count
	dec	di			; back up pointer so '\0' will...
					; ...overwrite the '\n'
appendnull:
	xor	ax,ax
	stosb

	mov	ax,word ptr [string]

if sizeD
	mov	dx,word ptr [string+2]
endif

done:


ifdef	_LOAD_DGROUP
	pop	ds
endif	;_LOAD_DGROUP

cEnd	<nolocals>

sEnd	code
	end
