/***
*getw.c - read a binary word from a stream
*
*   Copyright (c) 1985-1992, Microsoft Corporation.  All rights reserved.
*
*Purpose:
*   defines getw() - gets a binary integer from a stream
*
*******************************************************************************/

#include <stdio.h>
#include <register.h>
#include <assert.h>
#include <file2.h>
#include <internal.h>
#include <dos.h>


/***
*int _getw(stream) - read an int from a stream
*
*Purpose:
*   get n bytes (n=sizeof(int)); OR them together in proper order; high
*   byte first. check for EOF between getc's.
*   this routine should be machine independent.
*
*Entry:
*   FILE *stream - stream to read integer from
*
*Exit:
*   returns the int read from the stream
*   returns EOF if fails (but this is a legit int value, so
*   should test feof() or ferror().
*
*Exceptions:
*
*******************************************************************************/

int 
_getw (str)
FILE *str;
{
    REG1 FILE _NEAR_ *stream;
    REG2 int bytecount = sizeof(int);
    _WINSTATIC int word;
    char *byteptr = (char *)&word;
    int retval;

    assert(str != NULL);

    /* Init stream pointer */
    stream = (FILE _NEAR_ *) FP_OFF(str);


    while (bytecount--)
        *byteptr++ = (char)getc(stream);
    retval = ((feof(stream) || ferror(stream)) ? EOF : word);

    return(retval);
}
