	page	,132
	title	output - formatted output
;***
;output.asm - formatted output for printf, etc.
;
;	Copyright (c) 1988-1992, Microsoft Corporation. All rights reserved.
;
;Purpose:
;	defines _output() for formatted output by *printf.
;	if CPRFLAG is defined, defines cprintf instead.
;
;*******************************************************************************

.xlist
include version.inc
include cmacros.inc
.list
include stdio.inc
include math.inc
include fltintrn.inc
include os2dll.inc


if sizeC
	CPSIZE = 4
else
	CPSIZE = 2
endif					; size of code ptr


ifdef CPRFLAG
externP 	_putch			; console put character -- normal
else  ;CPRFLAG
externP 	_flsbuf 		; for putc
endif ;CPRFLAG
externP 	_chkstk 		; stack checking -- much local data

externCP	_cfltcvt_tab		; 6 entry float convert table

; size of conversion buffer (ANSI-specified minimum is 509)
BUFSIZE 	equ	512		; size of buffer for conversions
.ERRE		(BUFSIZE GT CVTBUFSIZE) ; ensure we can do fp conversions

; flag definitions for flag 1
FL_SIGN 	equ	01h		; put plus/minus sign in front
FL_SIGNSP	equ	02h		; put space/minus sign in front
FL_LEFT 	equ	04h		; left justify
FL_LEADZERO	equ	08h		; pad with leading zeros
FL_LONG 	equ	10h		; long value given (def: short)
FL_FAR		equ	20h		; far pointer given (def: model dep.)
FL_SIGNED	equ	40h		; signed data given (def: unsigned)
FL_ALTERNATE	equ	80h		; alternate form requested

; flag definitions for flag 2
FL_NEGATIVE	equ	01h		; value is negative
FL_FORCEOCTAL	equ	02h		; force 0 in front (for octals only)
FL_LONGDOUBLE	equ	04h		; long double value given
FL_SHORT	equ	08h		; short value given
FL_NEAR 	equ	10h		; near ptr given (useful only for %p)

; possible state values
ST_NORMAL	equ	0		; normal state -- just output char
ST_PERCENT	equ	1		; just read percent sign
ST_FLAG 	equ	2		; just read flag character
ST_WIDTH	equ	3		; just read width specification char
ST_DOT		equ	4		; just read dot
ST_PRECIS	equ	5		; just read precision spec. char
ST_SIZE 	equ	6		; just read size specification char
ST_TYPE 	equ	7		; just read type specification

; define character type values
CH_OTHER	equ	0		; character with no special meaning
CH_PERCENT	equ	1		; '%'
CH_DOT		equ	2		; '.'
CH_STAR 	equ	3		; '*'
CH_ZERO 	equ	4		; '0'
CH_DIGIT	equ	5		; '1'..'9'
CH_FLAG 	equ	6		; ' ', '+', '-', '#'
CH_SIZE 	equ	7		; 'h', 'l', 'L', 'N', 'F'
CH_TYPE 	equ	8		; type specification character

sBegin	DATA
	; The following defines the lookup table for changing states
	; This is actually two table combined into one.
	; The lower nybble of each byte gives the character
	; class of any character -- i.e.
	;   charclass = lookuptable[char-' '] & 0xF;
	; The upper nybble of each byte gives the next state to enter -- i.e.
	;   newstate = looptable[charclass][oldstate] >> 4;

	; The table below is generated by maketab.c -- use this program
	; to make changes.

lookuptable	db	 06h, 00h, 00h, 06h, 00h, 01h, 00h, 00h
		db	 10h, 00h, 03h, 06h, 00h, 06h, 02h, 10h
		db	 04h, 45h, 45h, 45h, 05h, 05h, 05h, 05h
		db	 05h, 35h, 30h, 00h, 50h, 00h, 00h, 00h
		db	 00h, 20h, 20h, 30h, 50h, 58h, 07h, 08h
		db	 00h, 30h, 30h, 30h, 57h, 50h, 07h, 00h
		db	 00h, 20h, 20h, 00h, 00h, 00h, 00h, 00h
		db	 08h, 60h, 60h, 60h, 60h, 60h, 60h, 00h
		db	 00h, 70h, 70h, 78h, 78h, 78h, 78h, 08h
		db	 07h, 08h, 00h, 00h, 07h, 00h, 08h, 08h
		db	 08h, 00h, 00h, 08h, 00h, 08h, 00h, 00h
		db	 08h

nullstring	db	'(null)'
nullstrlen	dw	6	; string to print when null string passed

sEnd	DATA

sBegin	CODE

assumes cs, CODE
assumes ds, DATA

ifdef CPRFLAG		; defining cprintf

cProc	_cprintf, <PUBLIC>, <SI, DI>
	parmDP	formatstring
	parmD	nextarg 	; to get position of arg list

cBegin	_cprintf

ifdef	_LOAD_DGROUP
	push	ds
	mov	ax, DGROUP
	mov	ds, ax
endif	;_LOAD_DGROUP		; load ds if necessary


	lea	ax, nextarg	; address of argument list
if sizeD
	push	ss
else
	ifdef _WINDOWS
		push	ss
	endif
endif
	push	ax		; push address of arg list
if sizeD
	push	word ptr (formatstring+2)	; format string: segment part
endif
	push	word ptr (formatstring) 	; format string: offset part

	call	near ptr output ; output the stuff

if sizeD
	add	sp,	8		; clean up stack
else
	ifdef _WINDOWS
		add	sp, 6
	else
		add	sp, 4		; clean up stack
	endif
endif


ifdef _LOAD_DGROUP
	pop	ds
endif	;_LOAD_DGROUP		; restore ds if saved before

cEnd				; return -- ax already has return value

endif	; CPRFLAG -- defining cprintf


page
;***
;int _output(stream, format, argptr) - formatted output (used internally only)
;
;Purpose:
;	_output performs printf-style output onto a stream.  It is called
;	by printf/fprintf/sprintf/vprintf/vfprintf/vsprintf to do the
;	dirty work.  In multi-thread situations, _output assumes that
;	the given stream is already locked.
;
;	Algorithm:
;	   The format string is parsed by using a finite-state machine
;	   based on the current state and the current character read
;	   from the format string.  Thus, looping is on a per-character
;	   basis, not a per conversion specifier basis.  Once the format
;	   specifying character is read, output is performed.
;
;Entry:
;	FILE *stream	-    stream for output
;	char *format	-    printf-style format string
;	void *argptr	-    pointer to the list of subsidiary arguments
;
;Exit:
;	If no output error occurs, returns the number of characters written
;	If an I/O error occurs, -1 is returned.
;
;Uses:
;	Performs I/O on the given stream by using the assembly
;	equivalent of getc/_getc_lk macros.
;
;*******************************************************************************

;jump table based on current state
jumptable	dw	codeOFFSET normal_state
		dw	codeOFFSET percent_state
		dw	codeOFFSET flag_state
		dw	codeOFFSET width_state
		dw	codeOFFSET dot_state
		dw	codeOFFSET precis_state
		dw	codeOFFSET size_state
		dw	codeOFFSET type_state

ifdef CPRFLAG	;defining cprintf

cProc	output, <NEAR>, <>	      ; static, near routine
        parmDP  format
    ifdef _WINDOWS
        parmD   arglist
    else
        parmDP  arglist
    endif

else		; defining normal _output routine

cProc	_output, <PUBLIC>, <>
	parmDP	stream
	parmDP	format
   parmDP  arglist

endif ;CPRFLAG

; define local variables manually (ick!) -- because we need stack checking

ifdef _WINDOWS
    if    sizeC
	BASE equ <(bp-2)>
    else
	BASE equ <bp>
    endif ;sizeC
else
	BASE equ <bp>
endif ;_WINDOWS

hexadd		equ	byte ptr [BASE-1]	  ; offset to add when hex converting
char		equ	byte ptr [BASE-2]	  ; character just read
flags		equ	word ptr [BASE-4]	  ; flag word (byte equates below)
flags2		equ	byte ptr [BASE-3]	  ; flag byte 2
flags1		equ	byte ptr [BASE-4]	  ; flag byte 1
state		equ	byte ptr [BASE-5]	  ; state we're in
radix		equ	byte ptr [BASE-6]	  ; radix to convert by
charsout	equ	word ptr [BASE-8]	  ; chars written so far
fldwidth	equ	word ptr [BASE-10]	  ; selected width
precision	equ	word ptr [BASE-12]	  ; selected precision
prefix		equ	byte ptr [BASE-14]	  ; up to two-byte prefix
prfxlen 	equ	word ptr [BASE-16]	  ; length of prefix
capexp		equ	word ptr [BASE-18]	  ; capital exponent?
buffer		equ	byte ptr [BASE-20-BUFSIZE]; buffer for conversions

LOCALDATSIZE	equ	20+BUFSIZE	; amount of local data

; begin procedure

cBegin _output

	mov	ax, LOCALDATSIZE
	callcrt _chkstk 		; allocate local data
	push	si
	push	di			; save registers

	xor	ax, ax
	mov	charsout, ax		; charsout = 0
	mov	state, al		; state = 0

loopagain:	; beginning of main loop

if sizeD
	les	si, format
	lods	byte ptr es:[si]
else
	mov	si, format
	lodsb
endif
	mov	word ptr(format), si
	mov	char, al		; char = *format++
	or	al, al			; char == '\0'?
	jz	done			; yes - end loop
	cmp	charsout, 0		; charsout < 0
	jge	loopok			; no - don't end loop
done:
	mov	ax, charsout		; return chars written
	jmp	return
loopok:
	mov	bx, dataOFFSET lookuptable  ; bx points to lookup table
	sub	al, ' ' 		; al = char - ' '
	cmp	al, 'x' - ' '		; beyond end of table?
	ja	main1			; yes, make it other char
	xlat				; al = lookuptable[al]
	and	al, 0fh 		; keep low nybble -- al has char class
	jmp	short main2
main1:
	mov	al, CH_OTHER		; not in table, must be other
main2:
	mov	cl, 3
	shl	al, cl			; al *= 8
	add	al, state		; al += state
	xlat				; al = lookuptable[al]
	inc	cl			; cl = 4
	shr	al, cl			; al >>= 4
	mov	state, al		; save new state
	cbw				; zero ah (al < 80h)
	; ax now has the state # (recall ah = 0) -- now we
	; use this to index into a jump table and go to
	; correct code for the current state
	mov	bx, ax
	shl	bx, 1			; index words (bx = state #)
	jmp	jumptable[bx]		; jump to correct state code

normal_state:
	; normal state - just output the character involved
	mov	dl, char		; dl = character to write
	mov	cx, 1			; write it once
	call	outpad			; output it
	jmp	short loopagain 	; goto top of loop

percent_state:
	; just read the percent character
	xor	ax, ax
	mov	prfxlen, ax		; prfxlen = 0
	mov	fldwidth, ax		; fldwidth = 0
	mov	capexp, ax		; capexp = 0
if sizeD
	mov	flags, FL_FAR		; large data -- default far ptrs
else
	mov	flags, ax		; small data -- default near ptrs
endif
	dec	ax
	mov	precision, ax		; precision = -1 (default)
	jmp	short loopagain 	; end of state code


flag_state:
; just read a flag, so set the flag bits accordingly
	mov	al, char
	cmp	al, '-'
	jne	fl1
	or	flags1, FL_LEFT 	; char=='-' => left justify
	jmp	short loopagain 	; end of state
fl1:
	cmp	al, '+'
	jne	fl2
	or	flags1, FL_SIGN 	; char=='-' => force sign indicator
	jmp	short loopagain 	; end of state
fl2:
	cmp	al, ' '
	jne	fl3
	or	flags1, FL_SIGNSP	; char==' ' => as above, but space not +
	jmp	loopagain		; end of state
fl3:
	cmp	al, '#'
	jne	fl4
	or	flags1, FL_ALTERNATE	; char=='#' => alternate form
	jmp	loopagain		; end of state
fl4:
; at this point we know char=='0', otherwise we couldn't be in this state
	or	flags1, FL_LEADZERO	; char=='0' => pade with leading zeros
	jmp	loopagain		; end of state


width_state:
	; just read a width specifier -- set width value
	mov	cl, char
	cmp	cl, '*' 		; char == '*'
	jne	widthdigit		; no - must be a digit
; char == '*' means get width from argument list
	call	getwordarg		; AX = word argument
	or	ax, ax			; ax < 0
	jns	storewidth		; no - do normal
	neg	ax			; ANSI: neg width means - flags
	or	flags1, FL_LEFT 	;    and positive width
	jmp	short storewidth
widthdigit:
; we just read a digit to add to the stored width value
	sub	cl, '0'
	xor	ch, ch			; dx = value of digit
	mov	ax, fldwidth
	mov	bx, 10
	mul	bx
	add	ax, cx			; fldwidth = 10*fldwidth + (digit-'0')
storewidth:
	mov	fldwidth, ax		; store width
	jmp	loopagain	  ; end of state


dot_state:
; We just read the dot -- char must == '.'; and all we need to do
; is zero the precision.
	mov	precision, 0		; zero precision, no longer default
	jmp	loopagain


precis_state:
	; just read a precision specifier -- set precision value
	mov	cl, char
	cmp	cl, '*' 		; char == '*'
	jne	precisdigit		; no - must be a digit
; char == '*' means get precision from argument list
	call	getwordarg		; AX = word argument
	or	ax, ax			; ax < 0
	jns	storeprecis		; no - do normal
	mov	ax,-1			; ANSI: neg precis. means default value
	jmp	short storeprecis
precisdigit:
; we just read a digit to add to the stored precision value
	sub	cl, '0'
	xor	ch, ch			; dx = value of digit
	mov	ax, precision
	mov	bx, 10
	mul	bx
	add	ax, cx			; precision = 10*precision + (digit-'0')
storeprecis:
	mov	precision, ax		; store precision
	jmp	loopagain		; end of state


size_state:
; just read a size specifier -- set the flags based on it
	mov	al, char
	cmp	al, 'l'
	jne	sz1
	or	flags1, FL_LONG 	; char=='l' or 'L' => long value given
	jmp	short szret
sz1:
	cmp	al, 'F'
	jne	sz2
	or	flags1, FL_FAR		; char=='F' => far ptr given
	jmp	short szret
sz2:
	cmp	al, 'N'
	jne	sz3
	or	flags2, FL_NEAR 	; char=='N' => near ptr given
	jmp	short szret
sz3:
	cmp	al, 'L'
	jne	sz4
	or	flags2, FL_LONGDOUBLE	; char=='L' => long double given
	jmp	short szret
	; fall thru to jump below
sz4:
; at this point we must have h given
	or	flags2, FL_SHORT	; char=='h' => short value given
szret:
	jmp	loopagain


type_state:
; OK, we just read the type specifier character, so we now actually
; have to format and 'print' the output.  We do this with the
; equivalent of a big switch statement to routines that formats the
; correct input and set ES:DI to point to the text to print
; and CX to the length of this output.	Common code later on
; then takes care of right/left justifying it.	Note that many of
; the cases share code; in particular all integer formatting is
; done in one place.

	mov	al, char
	cmp	al, 'd'
	jne	t1
	jmp	type_d
t1:
	cmp	al, 'i'
	jne	t2
	jmp	type_i
t2:
	cmp	al, 'u'
	jne	t3
	jmp	type_u
t3:
	cmp	al, 'X'
	jne	t4
	jmp	type_bigx
t4:
	cmp	al, 'x'
	jne	t5
	jmp	type_x
t5:
	cmp	al, 'o'
	jne	t6
	jmp	type_o
t6:
	cmp	al, 'c'
	je	type_c
	cmp	al, 's'
	je	type_s
	cmp	al, 'n'
	je	type_n
	cmp	al, 'p'
	je	type_p
	cmp	al, 'E'
	je	bigeg
	cmp	al, 'G'
	je	bigeg
; only possible remaining type is 'e', 'f', 'g' -- go to it
	jmp	type_efg	;'e', 'f', 'g' same destination
bigeg:
	jmp	type_bigeg

; Now we do case by case output formatting

type_c:
	; character output
	call	getwordarg		; AX = word argument
	lea	di, buffer
	push	ss
	pop	es			; es:di points to buffer
	stosb
	dec	di			; mov es:[di],al
	mov	cx, 1			; length of 1
	jmp	justify 		; goto general justify/output


type_s:
	; string output -- must handle both far and near
	; we have to know how much of the string to print -- rule is
	; all of it if precision is default, min(precision, length) if
	; precision given.  We do it simply as one computation here
	; because default precision stored as -1, which we treat
	; as 65535, the longest possible string length.
	; a null ptr is printed as '(null)'

	call	getptrarg		; read pointer into es:di
	or	di, di			; di == 0?
	jne	s2			; no - a normal string
	mov	ax, es
	or	ax, ax			; es == 0?
	jne	s2			; no - a normal string

	push	ds
	pop	es
	mov	di, dataOFFSET nullstring   ; es:di points to '(null)'
	mov	cx, nullstrlen		; cx has the length
	jmp	justify 		; go to justify routine
s2:
	push	di			; save di
	mov	cx, precision		; how much of string to scan
	jcxz	s3			; precision == 0; print nothing
	xor	al, al			; scan for '\0'
	repne scasb			; scan string - zero flag set if found
	jnz	s3			; no - we scanned exactly precision bytes
	dec	di			; yes - point to the null byte
s3:
	; di now points just beyond last byte to print
	pop	cx			; cx has old di
	sub	di, cx			; di has count of bytes
	xchg	cx, di			; di restored, cx has count of bytes
	jmp	justify 		; goto justify/output


type_n:
	; store count of characters written so far into int/long
	; pointed to by pointer argument.
	; NOTHING IS OUTPUT
	call	getptrarg		; read ptr into es:di
	mov	ax, charsout		; ax = number of characters written
	stosw				; mov es:[di], ax
	test	flags1, FL_LONG 	; a long value?
	jz	n1			; no - just a short
	xor	ax, ax			; clear ax
	stosw				; store high word (0)
n1:
	jmp	loopagain		; skip output, go straight to loop top


type_p:
	; write a pointer -- this is complicated by the fact that
	; the pointer could be 2 bytes or 4 bytes on the stack,
	; and that we can output in seg:off or off form.

	test	flags1, FL_FAR OR FL_LONG	; 4 or 2 bytes on stack?
	jnz	p4byte

	call	getwordarg		; get 2 byte ptr in AX
	jmp	short pshortfmt 	; read 2 bytes implies short format

p4byte:
	call	getlongarg		; get 4 byte ptr into DX:AX

	test	flags2, FL_SHORT OR FL_NEAR	; specified short format?
	jnz	 pshortfmt		 ; yes - goto short format

; output xxxx:yyyy
	mov	hexadd, 'A' - '9' - 1	; use uppercase hex
	mov	cx, 16			; radix 16
	push	ss
	pop	es			; es point to segment with buffer
	push	dx			; save segment
	xor	dx, dx			; no high word
	lea	di, buffer[8]		; point to end of offset spot in buffer
	mov	si, 4			; 4 digit output
	call	convert 		; convert and place in buffer

	mov	cx, 16			; radix 16 again
	lea	di, buffer[3]		; point to end of segment spot in buffer
	pop	ax			; ax has segment
	xor	dx, dx			; no high word
	mov	si, 4			; 4 digit output again
	call	convert 		; convert again

	mov	buffer[4], ':'		; put colon in middle
	mov	cx, 9			; 9 character output
	jmp	short p1		; skip near ptr code

pshortfmt:
;  output xxxx:yyyy
	mov	hexadd, 'A' - '9' - 1	; use uppercase hex
	mov	cx, 16			; radix 16
	push	ss
	pop	es			; es point to segment with buffer
	xor	dx, dx			; no high word
	lea	di, buffer[3];		; point to end of 4 byte buffer
	mov	si, 4			; 4 character output format
	call	convert 		; convert it into buffer
	mov	cx, 4			; 4 character text length

p1:
	lea	di, buffer		; di points to buffer, cx has length
	jmp	justify 		; justify and output


type_bigeg:
	inc	capexp			; capitalize exponent
type_efg:
	; floating point conversion -- this is relatively easy
	; because cfltcvt does the work for us

	or	flags1, FL_SIGNED	; this is a signed conversion
	mov	al, char
	or	al, 20h 		; convert to lower case
	cbw				; ax has format char is lower case
	mov	si, ax			; save it in si
	cmp	precision, 0
	jg	f2			; precision > 0, no adjustment
	je	f1			; precision = 0
	mov	precision, 6		; precision < 0, make it 6 (default)
	jmp	short f2
f1:
	cmp	ax, 'g' 		; using 'g' format?
	jne	f2			; no - no adjustment needed
	mov	precision, 1		; g format, 0 precision => precision=1
f2:
	lea	di, buffer		; ss:di points to buffer
	push	capexp
	push	precision
	push	si			; si has format character

if sizeD
	push	ss
else
ifdef _WINDOWS			; buffer in ss
	push	ss
endif
endif
	push	di			; push pointer to buffer

if sizeD
	push	word ptr (arglist[2])
else
ifdef _WINDOWS			; args in ss
	push	ss
endif
endif

	push	word ptr (arglist)	; push arglist

	test	flags2, FL_LONGDOUBLE
	jz	f3

	call	_cldcvt 		; do long double conversion
	add	word ptr (arglist), 10	; go to next argument (long double is 10 bytes)
	jmp	short f4
f3:
	call	_cfltcvt		; do float conversion
	add	word ptr (arglist), 8	; go to next argument (double is 8 bytes)
f4:
if sizeD
	add	sp, 14
else
ifdef _WINDOWS
	add	sp, 14
else
	add	sp, 10
endif
endif					; pop arguments


	test	flags1, FL_ALTERNATE	; alternate form?
	jz	f5			; nope, skip decimal forcing
	cmp	precision, 0		; precision == 0?
	jne	f5			; no - skip decimal forcing
	; '#' flag and precision == 0 => need to stick in a decimal point
if sizeD
	push	ss
else
	ifdef _WINDOWS
		push	ss
	endif
endif
	push	di			; push pointer to buffer
	call	_forcdecpt		; force decimal point
if sizeD
	add	sp, 4
else
	ifdef _WINDOWS
		add	sp, 4
	else
		add	sp, 2
	endif					; restore stack
endif					; restore stack

f5:
	cmp	si, 'g' 		; g format?
	jne	f6			; no - skip zero cropping
	test	flags, FL_ALTERNATE	; '#' given
	jnz	f6			; yes - skip zero cropping
	; 'g' format and no '#' flag => crop trailing zeros

if sizeD
	push	ss
else
	ifdef _WINDOWS
		push	ss
	endif
endif
	push	di			; push pointer to buffer
	call	_cropzeros		; crop zeros if g fmt and not alternate form
if sizeD
	add	sp, 4
else
	ifdef _WINDOWS
		add	sp, 4
	else
		add	sp, 2
	endif
endif					; restore stack

f6:
	push	ss
	pop	es			; es:di points to text to output
	cmp	byte ptr es:[di], '-'	; are we negative?
	jne	f7			; no -- skip it
	inc	di			; go beyond negative sign
	or	flags2, FL_NEGATIVE	; record negative number
f7:
	; now we must find length of buffer to output
	mov	cx, 65535		; scan long string
	push	di			; save di
	mov	al, 0			; scan for null byte
	repne scasb			; do the scan -- now di point just after null byte
	dec	di			; di points to null byte
	pop	cx			; cx has old di
	sub	di, cx			; di has length of string
	xchg	cx, di			; cx has length, di restored
	jmp	justify 		; done -- justify/output it


type_d: ;'d' and 'i' and synonymns
type_i:
	; signed decimal output
	or	flags1, FL_SIGNED
type_u:
	; unsigned decimal output
	mov	radix, 10
	jmp	short int_out		; go to common int formatting
type_bigx:
	; unsigned hex output, with ABCDEF
	mov	hexadd, 'A' - '9' - 1	; hex conversion constant, uppercase
	jmp	short dohex		; goto common hex formatting
type_x:
	; unsigned hex output, with abcdef
	mov	hexadd, 'a' - '9' - 1	; hex conversion constant, lowercase
  dohex:
	test	flags1, FL_ALTERNATE	; alternate form?
	jz	hex1			; no -- skip alternate formatting
	mov	prfxlen, 2		; yes, store 2-byte hex prefix
	mov	prefix, '0'		; byte 1: '0'
	mov	dl, 'x'-'a'+'9'+1
	add	dl, hexadd
	mov	prefix[1], dl		; byte 2: 'x' or 'X' as appropriate
  hex1:
	mov	radix, 16
	jmp	short int_out		; goto common int formatting
type_o:
	; unsigned octal output
	test	flags1, FL_ALTERNATE	; alternate form?
	jz	oct1			; no - skip alternate formatting
	or	flags2, FL_FORCEOCTAL	; force leading zero
  oct1:
	mov	radix, 8

int_out:
; Here is the common integer formatting routine.
; Note that shorts and ints are the same, so we ignore FL_SHORT

; 1.  Read argument from arglist; if a word, extend into long as appropriate
	test	flags1, FL_LONG 	; read long word?
	jz	int1			; no - read short word
	call	getlongarg		; read long word into dx:ax
	jmp	short int3
int1:
	call	getwordarg		; read short word into ax
	test	flags1, FL_SIGNED	; signed argument?
	jz	int2			; no - goto zeroextend
	cwd				; sign extend ax -> dx:ax
	jmp	short int3
 int2:
	xor	dx, dx			; zeroextend ax -> dx:ax

; 2.  If signed and negative, make it positive and remember the negative sign
int3:
	test	flags1, FL_SIGNED	; signed argument?
	jz	int4			; no - skip this
	or	dx, dx			; dx:ax < 0?
	jge	int4			; no - skip this
	or	flags2, FL_NEGATIVE	; remember negative sign
	neg	ax
	adc	dx, 0
	neg	dx			; dx:ax = -dx:ax

; 3.  Check the precision value for default; non-default turns off 0 flag (ANSI)
int4:
	cmp	precision, 0		; precision < 0 (default)
	jge	int5			; no - go turn off zero flag
	mov	precision, 1		; default precision = 1
	jmp	short int6		; don't turn off zero flag
int5:
	and	flags1, (NOT FL_LEADZERO) AND 0FFh	; turn off zero flags when explicit precision

; 4.  Check if data is zero, if so, turn off hex prefix
int6:
	mov	bx, ax
	or	bx, dx			; dx:ax == 0?
	jnz	int7			; no - skip this
	mov	prfxlen, 0		; kill hex prefix for zero data

; 5.  Convert data into ASCII characters
int7:
	lea	di, buffer[BUFSIZE-1]
	push	ss
	pop	es			; es:di points at end of buffer
	mov	cl, radix
	xor	ch, ch			; cx = radix
	mov	si, precision		; si = precision
	call	convert 		; Convert that sucker:
					; cx has length, es:di points to digits

; 6.  Force a leading 0 if FL_FORCEOCTAL set
	test	flags2, FL_FORCEOCTAL	; FORCEOCTAL flags set?
	jz	int8			; nope - don't do it
	jcxz	addzero 		; if printing no digits, add a zero
	cmp	byte ptr es:[di], '0'	; first digit already a 0?
	je	int8			; yep - don't do it
addzero:
	dec	di			; move back a digit
	mov	byte ptr es:[di], '0'	; add in a zero
	inc	cx			; increase number of bytes displayed

; 7.  Jump to general justify/output procedure
int8:
	jmp	short justify

; END of integer formatting.


justify:
; here we justify and output the results

; Find any prefix that we need to stick on -- note that hex prefixes
; have already been done.

	test	flags1, FL_SIGNED	; is this a signed conversion?
	jz	just3			; if not, no sign prefix
	test	flags2, FL_NEGATIVE	; a negative number?
	jz	just1			; no - skip
	mov	prefix[0], '-'		; prefix is '-'
	mov	prfxlen, 1		; prefix length = 1
	jmp	short just3		; skip next test
just1:
	test	flags1, FL_SIGN 	; forcing sign?
	jz	just2
	mov	prefix[0], '+'		; prefix is '+' (can't be negative)
	mov	prfxlen, 1		; prefix length = 1
	jmp	short just3		; skip next test ('+' overrides ' ')
just2:
	test	flags1, FL_SIGNSP	; forcing sign with blank?
	jz	just3
	mov	prefix[0], ' '		; prefix is ' ' (can't be negative)
	mov	prfxlen, 1		; prefix length = 1
just3:
	mov	ax, fldwidth
	sub	ax, cx			; subtract length of text
	sub	ax, prfxlen		; ax = width - textlen - prfxlen
	jge	just4			; ax < 0? skip next
	xor	ax, ax			; yes - ax = 0

; ax now has amount of padding, it's just a question of where to put it
; es:di points to output string, cx is length

just4:
	push	es
	push	di
	push	cx			; save these for now...

	test	flags1, FL_LEFT OR FL_LEADZERO	; left justify or lead zero?
	jnz	just5			; yes - don't pud padding now
	mov	cx, ax			; no - pad with spaces now
	mov	dl, ' ' 		; ' ' is pad character
	call	outpad			; ok for this to kill AX, won't need it anymore
just5:
	push	ax			; save pad count
	push	ss
	pop	es
	lea	di, prefix		; es:di points to prefix
	mov	cx, prfxlen		; length of prefix
	call	outch			; write prefix
	pop	ax			; recover pad count

	test	flags1, FL_LEADZERO	; use leading zeros?
	jz	just6			; no - don't put padding now
	test	flags1, FL_LEFT 	; left justifying?
	jnz	just6			; yes - skip ('-' overrides '0')
	mov	cx, ax			; amount of padding
	mov	dl, '0' 		; pad with zeros
	call	outpad			; write the zero padding
just6:
	pop	cx
	pop	di
	pop	es			; recover pointer to text
	push	ax			; save pad count
	call	outch			; output the text
	pop	ax			; recover pad count

	test	flags1, FL_LEFT 	; left justify?
	jz	just7			; no - don't put padding now
	mov	cx, ax			; amount of padding
	mov	dl, ' ' 		; pad with spaces
	call	outpad

; Now, everything has been output, just go back to start of loop.

just7:
	jmp	loopagain


; ------------------------------------------------------ ;
; END OF MAIN PROCEDURE -- NOW WE HAVE LOCAL SUBROUTINES ;
; USED BY THE MAIN PROCEDURE.				 ;
; ------------------------------------------------------ ;


; Read a word argument from the argument list
; Bumps arglist by 2 bytes
;   PARAMETERS: none
;   RETURNS:	word read in AX
;   TRASHES:	ES, SI

getwordarg:
if sizeD
	les	si, arglist
	lods	word ptr es:[si]	; ax = *arglist++
else
	mov	si, arglist
	lodsw				; ax = *arglist++
endif
	mov	word ptr (arglist), si	; store arglist back
	retn				; return near

; Read a long argument from the argument list
; Bumps arglist by 4 bytes
;   PARAMETERS: none
;   RETURNS:	long read in DX:AX
;   TRASHES:	ES, SI

getlongarg:
if sizeD
	les	si, arglist
	lods	word ptr es:[si]	; ax = *arglist++  (LSW)
	mov	dx, ax			; dx = LSW
	lods	word ptr es:[si]	; ax = *arglist++  (MSW)
	xchg	dx, ax			; ax = LSW, dx = MSW
else
	mov	si, arglist
	lodsw				; ax = *arglist++  (LSW)
	mov	dx, ax			; dx = LSW
	lodsw				; ax = *arglist++  (MSW)
	xchg	dx, ax			; ax = LSW, dx = MSW
endif
	mov	word ptr (arglist), si	; store arglist back
	retn				; return near

; Read a pointer from the argument list into es:di
; Size of pointer read depends on FL_FAR flag, if near, then
; ds is used as segment.
; Note that we don't need to check FL_NEAR, because in C/L models,
; near ptrs are passed as far, and in S/M models near is default
; anyway.
;
;   PARAMETERS: none
;   RETURNS:	ES:DI holds pointer read
;   TRASHES:	AX, DX

getptrarg:
	test	flags1, FL_FAR		; a far pointer
	jz	rp1			; no - goto near pointer code
	call	getlongarg		; read far pointer into dx:ax
	mov	es, dx
	mov	di, ax			; put far pointer into es:di
	retn
rp1:
	call	getwordarg		; read near pointer into ax
	mov	di, ax
	or	ax, ax			; read NULL ptr?
	jnz	rp2			; no - store ds
	mov	es, ax			; make long NULL ptr (ax = 0)
	retn
rp2:
	push	ds
	pop	es			; put near pointer into es:di
	retn


;  Put a character on the output string -- this is the
;  equivalent of putc_lk(c, f)
;    PARAMETERS: AL = character to write
;    RETURNS:	 AX == -1: error, AX == 0: no error
;    TRASHED:	 BX

putc:
ifdef CPRFLAG		; put on console instead of to stream

	cbw				; sign-extend char to AX
	push	es			; save es
	push	cx
	push	dx			; save cx and dx
	push	ax			; parameter: char to write
	callcrt _putch			; normal put console character
	add	sp, 2			; restore stack
	pop	dx
	pop	cx			; restore cx, dx
	pop	es			; restore es
	cmp	ax, -1			; error
	je	putchret		; yes - return -1 already in ax
	xor	ax, ax			; no - return 0

putchret:
	retn

else ; not CPRFLAG  -  now do normal stream output

	cbw				; sign-extend char to AX
if sizeD
	push	es			; save es
	push	di			; save di
	les	bx, stream		; es:bx is file *
	dec	es:[bx]._cnt		; --f->_cnt
	js	flush			; out of buffer, must flush
	mov	di, word ptr es:[bx]._ptr
	inc	word ptr es:[bx]._ptr
	mov	es, word ptr es:[bx+2]._ptr ; es:di = *f->_ptr++
	stosb				; mov es:[di],al - store byte
noerrret:
	xor	ax, ax			; no error
putcret:
	pop	di
	pop	es			; restore di, es
	retn				; return

flush:
	push	cx
	push	dx			; save cx and dx
	push	es
	push	bx			; push FILE *
	push	ax			; character to write
	callcrt _flsbuf 		; call _flsbuf(f, c)
	add	sp, 6
	pop	dx
	pop	cx			; restore cx and dx
	cmp	ax,-1			; check for an error
	jne	noerrret		; no error, go clear ax and return
	jmp	short putcret		; return with ax = -1

else ; not DataSize

	push	di			; save di
	mov	bx, stream		; bx is FILE *
	dec	[bx]._cnt		; dec f->_cnt
	js	flush			; out of buffer, must flush
	mov	di, [bx]._ptr
	inc	[bx]._ptr		; di = f->_ptr++
	mov	[di], al		; store byte to write
noerrret:
	xor	ax, ax			; no error
putcret:
	pop	di			; restore di
	retn				; return

flush:
	push	es
	push	cx
	push	dx			; save es, cx and dx
	push	bx			; push file *
	push	ax			; character to write
	callcrt _flsbuf 		; call _flsbuf(f, c)
	add	sp, 4
	pop	dx
	pop	cx
	pop	es			; restore es, cx and dx
	cmp	ax,-1			; check for an error
	jne	noerrret		; no error, go clear ax and return
	jmp	short putcret		; return with ax = -1

endif ; DataSize

endif ; CPRFLAG


;  Output a character string:
;  Put a (NOT zero-terminated) string of character on the output
;  stream, and increment the charsout variable
;    PARAMETERS:  ES:DI points to string to output
;		  CX specifies count of characters to output
;    RETURNS:	  none
;    TRASHES:	  AX, BX, CX, SI, ES
;    NOTES:	  The DI is used to accumulate possible error returns from
;		  the calls to putc. However, it is also saved and restored.

outch:
	jcxz	outchret		; no characters to write - return
	mov	si, di			; DS:SI points to string
	add	charsout, cx		; increase count of characters out
	push	di			; save di
	xor	di, di			; clear di
out1:
	lods	byte ptr es:[si]	; al = next char to write, inc si
	call	putc			; write that character
	or	di,ax			; or the return value into di
	loop	out1			; write another character if more

	or	di, di			; did an error occur?
	pop	di			; restore di
	jz	outchret		; no, return
	mov	charsout, -1		; yes - signal error, then return

outchret:
	retn

; Output a string of identical characters for padding
;   PARAMETERS:   DL = character to write, CX = count of character to write
;   RETURNS:	  none
;   TRASHES:	  AX, BX, CX
;   NOTES:	  The DI is used to accumulate possible error returns from
;		  the calls to putc. However, it is also saved and restored.

outpad:
	jcxz	outpadret		; no character to write -- return
	add	charsout, cx		; increase count of chars written
	push	di			; save di
	xor	di,di			; clear di
outpad1:
	mov	al, dl			; al = char to write
	call	putc			; write that character
	or	di,ax			; or the return value into di
	loop	outpad1 		; write anohter character if more

	or	di, di			; did an error occur?
	pop	di			; restore di
	jz	outpadret		; no - return
	mov	charsout, -1		; yes, signal error
outpadret:
	retn


; Convert a unsigned long to a character string.
;   PARAMETERS: DX:AX is number to convert
;		CX is radix to convert with
;		ES:DI points to where to store LAST digit
;		SI is min digits to store (pad with zero until this length)
;   (N.B. Converting 0 with SI==0 gives blank result: this is correct
;    and ANSI mandated)
;
;   RETURNS:	ES:DI points to first digit
;		CX is length of digit string
;
;   TRASHES:	AX, BX, DX, DI, SI
;
;
;   This algorithm does a 32 bit divided by 16 bit division to
;   get 32 bit quotient and 16 bit remainder like this (lifted from xtoa.asm):
;
;	   h/r	:  (h%r:l)/r
;      --------------
;   r  )   h	:   l
;	 r(h/r)
;	 ------------
;	  h%r	:   l
;	 r((h%r:l)/r)
;	 ------------
;		((h%r):l)%r	(REMAINDER)

convert:
	std				; store string in reverse
	push	di			; save di
	xchg	bx, ax			; dx = h, bx = l
conv1:
	or	si, si			; si == 0?
	jg	conv2			; count > 0 => keep converting
	or	bx, bx			; l == 0?
	jnz	conv2			; l != 0 => keep converting
	or	dx, dx			; h == 0?
	jnz	conv2			; h != 0 => keep converting
	jmp	short conv4		; stop converting (h:l==0, count<=0);
conv2:
	xchg	ax, dx			; ax = h, bx = l
	xor	dx, dx			; ax = h, bx = l, dx = 0
	div	cx			; ax = h/r, dx = h%r, bx = l
	xchg	ax, bx			; dx = h%r, ax = l, bx = h/r
	div	cx			; ax = (h%r:l)/r, dx = (h%r:l)%r, bx = h/r
					; bx:ax = (h:l)/r, dx = (h:l)%r
	xchg	ax, dx			; bx:dx = (h:l)/r, ax = (h:l)%r
	xchg	dx, bx			; dx:bx = (h:l)/r, ax = (h:l)%r
; now al has x%r, which is the numeric value of the digit -- now convert to ASCII
	add	al, '0'
	cmp	al, '9' 		; a normal digit?
	jbe	conv3			; yes, store it
	add	al, hexadd		; no, convert to hex
conv3:
	stosb				; *(es:di) = al, --di
	mov	ax, dx			; ax:bx = (h:l)/r
	dec	si			; stored a digit, subtract from count
	jmp	short conv1
; OK, we're done -- set up the return values
conv4:
	pop	cx			; cx has orginal di
	sub	cx, di			; subtract di now, get string length
	inc	di			; point to first digit
	cld				; must keep direction flag cleared
	retn

;return to user

return:
	pop	di
	pop	si			; pop register variables

cEnd

sEnd	CODE

	END
