/***
*printf.c - print formatted
*
*   Copyright (c) 1985-1992, Microsoft Corporation.  All rights reserved.
*
*Purpose:
*   defines printf() - print formatted data
*
*******************************************************************************/

#include <stdio.h>
#include <register.h>
#include <assert.h>
#include <stdarg.h>
#include <file2.h>
#include <internal.h>


/***
*int printf(format, ...) - print formatted data
*
*Purpose:
*   Prints formatted data on stdout using the format string to
*   format data and getting as many arguments as called for
*   Uses temporary buffering to improve efficiency.
*   _output does the real work here
*
*Entry:
*   char *format - format string to control data format/number of arguments
*   followed by list of arguments, number and type controlled by
*   format string
*
*Exit:
*   returns number of characters printed
*
*Exceptions:
*
*******************************************************************************/

int 
printf (const char *format, ...)

/*
 * stdout 'PRINT', 'F'ormatted
 */
{
    va_list arglist;
    REG1 FILE _NEAR_ *stream = stdout;
    REG2 int buffing;
    REG3 int retval;

    va_start(arglist, format);

    assert(format != NULL);

#ifdef  _QWIN
    /* If QWIN system is not used, stdout is not supported. */
    if (!_qwinused)
        return(EOF);
#endif



    buffing = _stbuf(stream);

    retval = _output(stream,format,arglist);

    _ftbuf(buffing, stream);


    return(retval);
}
