	page	,132
	title	fputc - write a character to an output stream
;***
;fputc.asm - read a character from a stream
;
;	Copyright (c) 1985-1992, Microsoft Corporation. All rights reserved.
;
;Purpose:
;	Defines fputc() and putc() (write a character to an output stream),
;	and fputchar() and putchar() (write a character to stdout).
;
;
;*******************************************************************************
;
; --- C VERSION OF ROUTINES
;
; #include <stdio.h>
; #include <register.h>
;
; int _LOAD_DS
; _fputchar (ch)
; REG1 int ch;
; {
;     return(putc(ch, stdout));
; }
;
;
; #include <stdio.h>
; #include <register.h>
; #include <assertm.h>
; #include <file2.h>
; #include <internal.h>
; #include <dos.h>
; #include <os2dll.h>
;
; int _LOAD_DS
; fputc (ch, str)
; int ch;
; FILE *str;
; {
;     REG1 FILE _NEAR_ *stream;
;     REG2 int retval;
; #ifdef MTHREAD
;     int index;
; #endif
;
;     assert(str,"str==NULL");
;
;     /* Init stream pointer */
;     stream = (FILE _NEAR_ *) FP_OFF(str);
;
; #ifdef MTHREAD
;     index = _iob_index(stream);
; #endif
;     _lock_str(index);
;     retval = _putc_lk(ch,stream);
;     _unlock_str(index);
;
;     return(retval);
; }
;
; --- END OF C VERSION
;

.xlist
include version.inc
include cmacros.inc
include stdio.inc
include os2dll.inc
.list

externP _flsbuf 			; flush stream buffer



sBegin	data
	assumes ds,data

externW _iob

ifdef _QWIN
externW _qwinused			; QWIN in use flag
endif

sEnd	data


sBegin code
	assumes cs,code
	assumes ds,data


;***
;int _fputchar(chr), putchar(char) - write chr to stdout
;
;Purpose:
;	Write the given character to stdout. putchar() is normally a macro,
;	but must also be available as a true function for ANSI. The function
;	version of putchar() and fputchar() are identical.
;
;Entry:
;	int chr - character to output
;
;Exit:
;	returns character written if successful
;	returns EOF if failure
;
;Exceptions:
;
;*******************************************************************************


ifndef	_WINDLL

cProc	putchar,<PUBLIC>,<>

cBegin	<nogen>
cEnd	<nogen>

cProc	_fputchar,<PUBLIC>,<>

	parmW	chr

cBegin
ifdef	_QWIN
ifndef	_BAT16
	cmp	[_qwinused],0		; QWIN in use?
	jne	@F			; yes, stdout is legal
	mov	ax,EOF			; nope, return an error
	jmp	short return
@@:
endif
endif
	mov	bx,stdout		; bx = stream (stdout)
	jmp	short havestr		; jump to common code
cEnd	<nogen>

endif	;!_WINDLL


;***
;int fputc(chr, stream), putc(chr, stream) - write chr to stream
;
;Purpose:
;	Write the specified character to the given output stream. putc() is
;	normally a macro, but must also be available as a true function for
;	ANSI. The function version of putc() and fputch() are identical.
;
;Entry:
;	char chr     - character to be written out
;	FILE *stream - stream to write to
;
;Exit:
;	returns the character if succesfull
;	returns EOF if failure
;
;Exceptions:
;
;*******************************************************************************

	EVEN				; force word alignment

cProc	putc,<PUBLIC>,<>

cBegin	<nogen>
cEnd	<nogen>

cProc	fputc,<PUBLIC>,<>

	parmW	chr
	parmDP	stream

cBegin

; The following instruction is only place where the argument stream is
; referenced!

	mov	bx,word ptr [stream]	; bx = stream

; fputchar() and putchar() enter here. The remainder of the code is common
; to all four of the put-a-character functions.

havestr::

ifdef	_LOAD_DGROUP
	push	ds
	mov	ax,DGROUP
	mov	ds,ax
endif	;_LOAD_DGROUP


	dec	[bx]._cnt
	js	doflsbuf		; go call _flsbuf if _cnt < 0
	inc	word ptr [bx]._ptr

if	sizeD
	les	bx,[bx]._ptr
	mov	al,byte ptr [chr]
	mov	byte ptr es:[bx-1],al	; copy chr into stream buffer
else	;not sizeD
	mov	bx,[bx]._ptr
	mov	al,byte ptr [chr]
	mov	byte ptr [bx-1],al	; copy chr into stream buffer
endif	;sizeD

	xor	ah,ah			; zero out ah
	jmp	short done

doflsbuf:
if	sizeD
	push	ds
endif
	push	bx			; push stream pointer

	push	[chr]			; push character to write out

	callcrt _flsbuf

if	sizeD
	add	sp,6			; clean off stack
else	;not sizeD
	pop	bx			; clean off stack
	pop	bx
endif	;sizeD

done:

ifdef	_LOAD_DGROUP
	pop	ds
endif	;_LOAD_DGROUP

return:

cEnd	<nolocals>

sEnd	code
	end
