/***
*puts.c - put a string to stdout
*
*   Copyright (c) 1985-1992, Microsoft Corporation.  All rights reserved.
*
*Purpose:
*   defines puts() - put a string to stdout
*
*******************************************************************************/

#include <stdio.h>
#include <string.h>
#include <register.h>
#include <assert.h>
#include <file2.h>
#include <internal.h>


/***
*int puts(string) - put a string to stdout with newline
*
*Purpose:
*   Write a string to stdout; don't include '\0' but append '\n'.  Uses
*   temporary buffering for efficiency on stdout if unbuffered.
*
*Entry:
*   char *string - string to output
*
*Exit:
*   Good return = 0
*   Error return = EOF
*
*Exceptions:
*
*******************************************************************************/

int 
puts (string)
const char *string;
{
    REG1 FILE _NEAR_ *stream = stdout;
    REG4 int buffing;
    REG2 unsigned int length;
    REG3 unsigned int ndone;
    int retval;

    assert(string != NULL);
#ifdef  _BAT16
    printf(string);
#endif
#ifdef  _QWIN
    /* If QWIN system is not used, stdout is not supported. */
    if (!_qwinused)
        return(EOF);
#endif

    length = strlen(string);
    buffing = _stbuf(stream);

    ndone = fwrite(string,1,length,stream);

    if (ndone == length) {
        putc('\n',stream);
        retval = 0; /* success */
    }
    else
        retval = EOF;    /* error */

    _ftbuf(buffing, stream);

    return(retval);
}
