/***
*putw.c - put a binary int to output stream
*
*   Copyright (c) 1985-1992, Microsoft Corporation.  All rights reserved.
*
*Purpose:
*   defines putw() - puts a binary int to an output stream
*
*******************************************************************************/

#include <stdio.h>
#include <register.h>
#include <assert.h>
#include <file2.h>
#include <internal.h>
#include <dos.h>


/***
*int _putw(word, stream) - write a binary int to an output stream
*
*Purpose:
*   Writes sizeof(int) bytes to the output stream, high byte first.
*   This routine should be machine independent.
*
*Entry:
*   int word - integer to write
*   FILE *stream - stream to write to
*
*Exit:
*   returns the word put to the stream
*   returns EOF if error, but this is a legit int value, so should
*   test with feof() or ferror().
*
*Exceptions:
*
*******************************************************************************/

#ifdef _WINDLL
static int dsword;  /* get a word in dgroup */
#else
#define dsword word
#endif


int 
_putw (word, str)
int word;
FILE *str;
{
    REG1 FILE _NEAR_ *stream;
    REG3 int bytecount = sizeof(int);
    REG2 char *byteptr = (char *)&dsword;
    int retval;

    assert(str != NULL);

#ifdef  _WINDLL
    /* Move word value from stack to dgroup */
    dsword = word;
#endif

    /* Init stream pointer */
    stream = (FILE _NEAR_ *) FP_OFF(str);


    while (bytecount--)
    {
        putc(*byteptr,stream);
        ++byteptr;
    }
    retval = (ferror(stream) ? EOF : dsword);

    return(retval);
}
