/***
*rewind.c - rewind a stream
*
*   Copyright (c) 1985-1992, Microsoft Corporation.  All rights reserved.
*
*Purpose:
*   defines rewind() - rewinds a stream to the beginning.
*
*
*******************************************************************************/

#include <stdio.h>
#include <register.h>
#include <file2.h>
#include <assert.h>
#include <io.h>
#include <msdos.h>
#include <internal.h>
#include <dos.h>


/***
*void rewind(stream) - rewind a string
*
*Purpose:
*   Back up a stream to the beginning (if not terminal).  First flush it.
*   If read/write, allow next i/o operation to set mode.
*
*Entry:
*   FILE *stream - file to rewind
*
*Exit:
*   returns 0 if success
*   returns -1 if fails
*
*Exceptions:
*
*******************************************************************************/

void  rewind (str)
FILE *str;
{
    REG1 FILE _NEAR_ *stream;
    REG2 int fd;

    assert(str != NULL);

    /* Init stream pointer */
    stream = (FILE _NEAR_ *) FP_OFF(str);
    fd = _fileno(stream);

    /* Get the stream index and lock the file */

    /* Flush the stream */
    _flush(stream);

    /* Clear errors */
    stream->_flag &= ~(_IOERR|_IOEOF);
    _osfile[fd] &= ~(FEOFLAG);

    /* Set flags */
    /* [note: _flush set _cnt=0 and _ptr=_base] */
    if (stream->_flag & _IORW)
        stream->_flag &= ~(_IOREAD|_IOWRT);

    /* Position to beginning of file */
    _lseek(fd,0L,0);

    /* unlock stream */
}
