/***
*rmtmp.c - remove temporary files created by tmpfile.
*
*   Copyright (c) 1985-1992, Microsoft Corporation.  All rights reserved.
*
*Purpose:
*
*******************************************************************************/

#include <stdio.h>
#include <file2.h>
#include <register.h>
#include <internal.h>


/***
*int _rmtmp() - closes and removes temp files created by tmpfile
*
*Purpose:
*   closes and deletes all open files that were created by tmpfile.
*
*Entry:
*   None.
*
*Exit:
*   returns number of streams closed
*
*Exceptions:
*
*******************************************************************************/

int 
_rmtmp ()
{
    REG1 FILE _NEAR_ *stream = _iob;
    REG2 int count = 0;


    for (; stream <= _lastiob; stream++) {


        if (inuse(stream) && _tmpnum(stream) ) {
            fclose(stream);
            count++;
        }

    }


    return(count);
}
