/***
*scanf.c - read formatted data from stdin
*
*   Copyright (c) 1985-1992, Microsoft Corporation.  All rights reserved.
*
*Purpose:
*   defines scanf() - reads formatted data from stdin
*
*******************************************************************************/

#include <stdio.h>
#include <register.h>
#include <assert.h>
#include <stdarg.h>
#include <file2.h>
#include <internal.h>


/***
*int scanf(format, ...) - read formatted data from stdin
*
*Purpose:
*   Reads formatted data from stdin into arguments.  _input does the real
*   work here.
*
*Entry:
*   char *format - format string
*   followed by list of pointers to storage for the data read.  The number
*   and type are controlled by the format string.
*
*Exit:
*   returns number of fields read and assigned
*
*Exceptions:
*
*******************************************************************************/

int 
scanf (const char *format, ...)

/*
 * stdin 'SCAN', 'F'ormatted
 */
{
    REG1 FILE _NEAR_ *stream = stdin;
    REG2 int retval;

    va_list arglist;

    va_start(arglist, format);

    assert(format != NULL);

#ifdef  _QWIN
    /* If QWIN system is not used, stdin is not supported */
    if (!_qwinused)
        return(EOF);
#endif



    retval = (_input(stream,(const unsigned char *)format,arglist));


    return(retval);
}
