/***
*setbuf.c - give new file buffer
*
*   Copyright (c) 1985-1992, Microsoft Corporation.  All rights reserved.
*
*Purpose:
*   defines setbuf() - given a buffer to a stream or make it unbuffered
*
*******************************************************************************/

#include <assert.h>
#include <stdio.h>


/***
*void setbuf(stream, buffer) - give a buffer to a stream
*
*Purpose:
*   Allow user to assign his/her own buffer to a stream.
*       if buffer is not NULL, it must be BUFSIZ in length.
*       if buffer is NULL, stream will be unbuffered.
*
*   Since setbuf()'s functionality is a subset of setvbuf(), simply
*   call the latter routine to do the actual work.
*
*Entry:
*   FILE *stream - stream to be buffered or unbuffered
*   char *buffer - buffer of size BUFSIZ or NULL
*
*Exit:
*   None.
*
*Exceptions:
*
*******************************************************************************/

void 
setbuf (stream, buffer)
FILE *stream;
char *buffer;
{
    assert(stream != NULL);

    if (buffer == NULL)
        setvbuf(stream, NULL, _IONBF, 0);
    else
        setvbuf(stream, buffer, _IOFBF, BUFSIZ);

}
